/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ChatFavorite;
import com.mypurecloud.sdk.v2.model.ChatUserRef;
import com.mypurecloud.sdk.v2.model.Image;
import com.mypurecloud.sdk.v2.model.Room;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ChatItem
implements Serializable {
    private String id = null;
    private String name = null;
    private Boolean open = null;
    private ChatFavorite favorite = null;
    private List<Image> images = new ArrayList<Image>();
    private Date dateLastMessage = null;
    private Date dateClosed = null;
    private ChatUserRef user = null;
    private Room room = null;
    private ChatTypeEnum chatType = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ChatItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChatItem open(Boolean open) {
        this.open = open;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If the chat is open")
    @JsonProperty(value="open")
    public Boolean getOpen() {
        return this.open;
    }

    public void setOpen(Boolean open) {
        this.open = open;
    }

    public ChatItem favorite(ChatFavorite favorite) {
        this.favorite = favorite;
        return this;
    }

    @ApiModelProperty(example="null", value="The favorite entity for the chat, only appears if the chat is favorited")
    @JsonProperty(value="favorite")
    public ChatFavorite getFavorite() {
        return this.favorite;
    }

    public void setFavorite(ChatFavorite favorite) {
        this.favorite = favorite;
    }

    public ChatItem images(List<Image> images) {
        this.images = images;
        return this;
    }

    @ApiModelProperty(example="null", value="Avatar images for the chat")
    @JsonProperty(value="images")
    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public ChatItem dateLastMessage(Date dateLastMessage) {
        this.dateLastMessage = dateLastMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the last message. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLastMessage")
    public Date getDateLastMessage() {
        return this.dateLastMessage;
    }

    public void setDateLastMessage(Date dateLastMessage) {
        this.dateLastMessage = dateLastMessage;
    }

    public ChatItem dateClosed(Date dateClosed) {
        this.dateClosed = dateClosed;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the chat was closed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateClosed")
    public Date getDateClosed() {
        return this.dateClosed;
    }

    public void setDateClosed(Date dateClosed) {
        this.dateClosed = dateClosed;
    }

    public ChatItem user(ChatUserRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="The other 1on1 user")
    @JsonProperty(value="user")
    public ChatUserRef getUser() {
        return this.user;
    }

    public void setUser(ChatUserRef user) {
        this.user = user;
    }

    public ChatItem room(Room room) {
        this.room = room;
        return this;
    }

    @ApiModelProperty(example="null", value="The room of the chat")
    @JsonProperty(value="room")
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public ChatItem chatType(ChatTypeEnum chatType) {
        this.chatType = chatType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of chat")
    @JsonProperty(value="chatType")
    public ChatTypeEnum getChatType() {
        return this.chatType;
    }

    public void setChatType(ChatTypeEnum chatType) {
        this.chatType = chatType;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatItem chatItem = (ChatItem)o;
        return Objects.equals(this.id, chatItem.id) && Objects.equals(this.name, chatItem.name) && Objects.equals(this.open, chatItem.open) && Objects.equals(this.favorite, chatItem.favorite) && Objects.equals(this.images, chatItem.images) && Objects.equals(this.dateLastMessage, chatItem.dateLastMessage) && Objects.equals(this.dateClosed, chatItem.dateClosed) && Objects.equals(this.user, chatItem.user) && Objects.equals(this.room, chatItem.room) && Objects.equals((Object)this.chatType, (Object)chatItem.chatType) && Objects.equals(this.selfUri, chatItem.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.open, this.favorite, this.images, this.dateLastMessage, this.dateClosed, this.user, this.room, this.chatType, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChatItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    open: ").append(this.toIndentedString(this.open)).append("\n");
        sb.append("    favorite: ").append(this.toIndentedString(this.favorite)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    dateLastMessage: ").append(this.toIndentedString(this.dateLastMessage)).append("\n");
        sb.append("    dateClosed: ").append(this.toIndentedString(this.dateClosed)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    chatType: ").append(this.toIndentedString((Object)this.chatType)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ChatTypeEnumDeserializer.class)
    public static enum ChatTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ADHOC("adhoc"),
        ACD("acd"),
        GROUP("group"),
        ONEONONE("oneOnOne"),
        SUPERVISORASSISTANCE("supervisorAssistance");

        private String value;

        private ChatTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ChatTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ChatTypeEnum value : ChatTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ChatTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ChatTypeEnumDeserializer
    extends StdDeserializer<ChatTypeEnum> {
        public ChatTypeEnumDeserializer() {
            super(ChatTypeEnumDeserializer.class);
        }

        public ChatTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ChatTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

