/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.BuForecastStaffingRequirementsResult;
import com.mypurecloud.sdk.v2.model.BuShortTermForecastReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BuForecastStaffingRequirementsResultResponse
implements Serializable {
    private String businessUnitId = null;
    private BuShortTermForecastReference forecast = null;
    private Date referenceStartDate = null;
    private Integer weekCount = null;
    private Integer intervalLengthMinutes = null;
    private StateEnum state = null;
    private List<BuForecastStaffingRequirementsResult> results = new ArrayList<BuForecastStaffingRequirementsResult>();

    public BuForecastStaffingRequirementsResultResponse businessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the business unit to which the forecast staffing requirements belongs")
    @JsonProperty(value="businessUnitId")
    public String getBusinessUnitId() {
        return this.businessUnitId;
    }

    public void setBusinessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
    }

    public BuForecastStaffingRequirementsResultResponse forecast(BuShortTermForecastReference forecast) {
        this.forecast = forecast;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The forecast reference")
    @JsonProperty(value="forecast")
    public BuShortTermForecastReference getForecast() {
        return this.forecast;
    }

    public void setForecast(BuShortTermForecastReference forecast) {
        this.forecast = forecast;
    }

    public BuForecastStaffingRequirementsResultResponse referenceStartDate(Date referenceStartDate) {
        this.referenceStartDate = referenceStartDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The reference start date for interval-based data for this forecast as an ISO-8601 string")
    @JsonProperty(value="referenceStartDate")
    public Date getReferenceStartDate() {
        return this.referenceStartDate;
    }

    public void setReferenceStartDate(Date referenceStartDate) {
        this.referenceStartDate = referenceStartDate;
    }

    public BuForecastStaffingRequirementsResultResponse weekCount(Integer weekCount) {
        this.weekCount = weekCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of weeks in this forecast")
    @JsonProperty(value="weekCount")
    public Integer getWeekCount() {
        return this.weekCount;
    }

    public void setWeekCount(Integer weekCount) {
        this.weekCount = weekCount;
    }

    public BuForecastStaffingRequirementsResultResponse intervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The period/interval in minutes for which to aggregate the data")
    @JsonProperty(value="intervalLengthMinutes")
    public Integer getIntervalLengthMinutes() {
        return this.intervalLengthMinutes;
    }

    public void setIntervalLengthMinutes(Integer intervalLengthMinutes) {
        this.intervalLengthMinutes = intervalLengthMinutes;
    }

    public BuForecastStaffingRequirementsResultResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the staffing requirements generation")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public BuForecastStaffingRequirementsResultResponse results(List<BuForecastStaffingRequirementsResult> results) {
        this.results = results;
        return this;
    }

    @ApiModelProperty(example="null", value="The forecast staffing requirement results, Will be populated when state == 'Complete'")
    @JsonProperty(value="results")
    public List<BuForecastStaffingRequirementsResult> getResults() {
        return this.results;
    }

    public void setResults(List<BuForecastStaffingRequirementsResult> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuForecastStaffingRequirementsResultResponse buForecastStaffingRequirementsResultResponse = (BuForecastStaffingRequirementsResultResponse)o;
        return Objects.equals(this.businessUnitId, buForecastStaffingRequirementsResultResponse.businessUnitId) && Objects.equals(this.forecast, buForecastStaffingRequirementsResultResponse.forecast) && Objects.equals(this.referenceStartDate, buForecastStaffingRequirementsResultResponse.referenceStartDate) && Objects.equals(this.weekCount, buForecastStaffingRequirementsResultResponse.weekCount) && Objects.equals(this.intervalLengthMinutes, buForecastStaffingRequirementsResultResponse.intervalLengthMinutes) && Objects.equals((Object)this.state, (Object)buForecastStaffingRequirementsResultResponse.state) && Objects.equals(this.results, buForecastStaffingRequirementsResultResponse.results);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.businessUnitId, this.forecast, this.referenceStartDate, this.weekCount, this.intervalLengthMinutes, this.state, this.results});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuForecastStaffingRequirementsResultResponse {\n");
        sb.append("    businessUnitId: ").append(this.toIndentedString(this.businessUnitId)).append("\n");
        sb.append("    forecast: ").append(this.toIndentedString(this.forecast)).append("\n");
        sb.append("    referenceStartDate: ").append(this.toIndentedString(this.referenceStartDate)).append("\n");
        sb.append("    weekCount: ").append(this.toIndentedString(this.weekCount)).append("\n");
        sb.append("    intervalLengthMinutes: ").append(this.toIndentedString(this.intervalLengthMinutes)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        ERROR("Error");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

