/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SyncStatusRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseSynchronizeJobRequest {
    private String knowledgeBaseId;
    private String syncJobId;
    private SyncStatusRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseSynchronizeJobRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getSyncJobId() {
        return this.syncJobId;
    }

    public void setSyncJobId(String syncJobId) {
        this.syncJobId = syncJobId;
    }

    public PatchKnowledgeKnowledgebaseSynchronizeJobRequest withSyncJobId(String syncJobId) {
        this.setSyncJobId(syncJobId);
        return this;
    }

    public SyncStatusRequest getBody() {
        return this.body;
    }

    public void setBody(SyncStatusRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseSynchronizeJobRequest withBody(SyncStatusRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseSynchronizeJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SyncStatusRequest> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseSynchronizeJobRequest.");
        }
        if (this.syncJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'syncJobId' when building request for PatchKnowledgeKnowledgebaseSynchronizeJobRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseSynchronizeJobRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/synchronize/jobs/{syncJobId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("syncJobId", this.syncJobId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String syncJobId, SyncStatusRequest body) {
        return new Builder().withRequiredParams(knowledgeBaseId, syncJobId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseSynchronizeJobRequest request = new PatchKnowledgeKnowledgebaseSynchronizeJobRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withSyncJobId(String syncJobId) {
            this.request.setSyncJobId(syncJobId);
            return this;
        }

        public Builder withBody(SyncStatusRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String syncJobId, SyncStatusRequest body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setSyncJobId(syncJobId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseSynchronizeJobRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseSynchronizeJobRequest.");
            }
            if (this.request.syncJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'syncJobId' when building request for PatchKnowledgeKnowledgebaseSynchronizeJobRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseSynchronizeJobRequest.");
            }
            return this.request;
        }
    }
}

