/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneyViewVersionJobResultsRequest {
    private String viewId;
    private String journeyViewVersion;
    private String jobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public GetJourneyViewVersionJobResultsRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getJourneyViewVersion() {
        return this.journeyViewVersion;
    }

    public void setJourneyViewVersion(String journeyViewVersion) {
        this.journeyViewVersion = journeyViewVersion;
    }

    public GetJourneyViewVersionJobResultsRequest withJourneyViewVersion(String journeyViewVersion) {
        this.setJourneyViewVersion(journeyViewVersion);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public GetJourneyViewVersionJobResultsRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneyViewVersionJobResultsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionJobResultsRequest.");
        }
        if (this.journeyViewVersion == null) {
            throw new IllegalStateException("Missing the required parameter 'journeyViewVersion' when building request for GetJourneyViewVersionJobResultsRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetJourneyViewVersionJobResultsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/views/{viewId}/versions/{journeyViewVersion}/jobs/{jobId}/results").withPathParameter("viewId", this.viewId).withPathParameter("journeyViewVersion", this.journeyViewVersion).withPathParameter("jobId", this.jobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String journeyViewVersion, String jobId) {
        return new Builder().withRequiredParams(viewId, journeyViewVersion, jobId);
    }

    public static class Builder {
        private final GetJourneyViewVersionJobResultsRequest request = new GetJourneyViewVersionJobResultsRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withJourneyViewVersion(String journeyViewVersion) {
            this.request.setJourneyViewVersion(journeyViewVersion);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withRequiredParams(String viewId, String journeyViewVersion, String jobId) {
            this.request.setViewId(viewId);
            this.request.setJourneyViewVersion(journeyViewVersion);
            this.request.setJobId(jobId);
            return this;
        }

        public GetJourneyViewVersionJobResultsRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionJobResultsRequest.");
            }
            if (this.request.journeyViewVersion == null) {
                throw new IllegalStateException("Missing the required parameter 'journeyViewVersion' when building request for GetJourneyViewVersionJobResultsRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetJourneyViewVersionJobResultsRequest.");
            }
            return this.request;
        }
    }
}

