/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AvailabilityRange;
import com.mypurecloud.sdk.v2.model.RequiredLocalDateRange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FixedAvailability
implements Serializable {
    private AvailabilityRange availabilityRange = null;
    private RequiredLocalDateRange dateRange = null;
    private List<DaysOfWeekEnum> daysOfWeek = new ArrayList<DaysOfWeekEnum>();

    public FixedAvailability availabilityRange(AvailabilityRange availabilityRange) {
        this.availabilityRange = availabilityRange;
        return this;
    }

    @ApiModelProperty(example="null", value="The range of time of day the activity can be scheduled")
    @JsonProperty(value="availabilityRange")
    public AvailabilityRange getAvailabilityRange() {
        return this.availabilityRange;
    }

    public void setAvailabilityRange(AvailabilityRange availabilityRange) {
        this.availabilityRange = availabilityRange;
    }

    public FixedAvailability dateRange(RequiredLocalDateRange dateRange) {
        this.dateRange = dateRange;
        return this;
    }

    @ApiModelProperty(example="null", value="The range of date for which the activity plan could be scheduled")
    @JsonProperty(value="dateRange")
    public RequiredLocalDateRange getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(RequiredLocalDateRange dateRange) {
        this.dateRange = dateRange;
    }

    public FixedAvailability daysOfWeek(List<DaysOfWeekEnum> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The days of week available for scheduling. Empty list or null means daysOfWeek is not considered")
    @JsonProperty(value="daysOfWeek")
    public List<DaysOfWeekEnum> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<DaysOfWeekEnum> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedAvailability fixedAvailability = (FixedAvailability)o;
        return Objects.equals(this.availabilityRange, fixedAvailability.availabilityRange) && Objects.equals(this.dateRange, fixedAvailability.dateRange) && Objects.equals(this.daysOfWeek, fixedAvailability.daysOfWeek);
    }

    public int hashCode() {
        return Objects.hash(this.availabilityRange, this.dateRange, this.daysOfWeek);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FixedAvailability {\n");
        sb.append("    availabilityRange: ").append(this.toIndentedString(this.availabilityRange)).append("\n");
        sb.append("    dateRange: ").append(this.toIndentedString(this.dateRange)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DaysOfWeekEnumDeserializer.class)
    public static enum DaysOfWeekEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private DaysOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DaysOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DaysOfWeekEnum value : DaysOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DaysOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DaysOfWeekEnumDeserializer
    extends StdDeserializer<DaysOfWeekEnum> {
        public DaysOfWeekEnumDeserializer() {
            super(DaysOfWeekEnumDeserializer.class);
        }

        public DaysOfWeekEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DaysOfWeekEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

