/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetKnowledgeKnowledgebaseImportJobRequest {
    private String knowledgeBaseId;
    private String importJobId;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public GetKnowledgeKnowledgebaseImportJobRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getImportJobId() {
        return this.importJobId;
    }

    public void setImportJobId(String importJobId) {
        this.importJobId = importJobId;
    }

    public GetKnowledgeKnowledgebaseImportJobRequest withImportJobId(String importJobId) {
        this.setImportJobId(importJobId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetKnowledgeKnowledgebaseImportJobRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetKnowledgeKnowledgebaseImportJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for GetKnowledgeKnowledgebaseImportJobRequest.");
        }
        if (this.importJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'importJobId' when building request for GetKnowledgeKnowledgebaseImportJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/import/jobs/{importJobId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("importJobId", this.importJobId).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String importJobId) {
        return new Builder().withRequiredParams(knowledgeBaseId, importJobId);
    }

    public static class Builder {
        private final GetKnowledgeKnowledgebaseImportJobRequest request = new GetKnowledgeKnowledgebaseImportJobRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withImportJobId(String importJobId) {
            this.request.setImportJobId(importJobId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String importJobId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setImportJobId(importJobId);
            return this;
        }

        public GetKnowledgeKnowledgebaseImportJobRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for GetKnowledgeKnowledgebaseImportJobRequest.");
            }
            if (this.request.importJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'importJobId' when building request for GetKnowledgeKnowledgebaseImportJobRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        URLS("urls");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

