/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteAssistantQueueRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteAssistantQueuesRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteAssistantRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantQueueRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantQueuesRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantsQueuesRequest;
import com.mypurecloud.sdk.v2.api.request.GetAssistantsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAssistantQueuesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAssistantRequest;
import com.mypurecloud.sdk.v2.api.request.PostAssistantsRequest;
import com.mypurecloud.sdk.v2.api.request.PutAssistantQueueRequest;
import com.mypurecloud.sdk.v2.model.Assistant;
import com.mypurecloud.sdk.v2.model.AssistantListing;
import com.mypurecloud.sdk.v2.model.AssistantQueue;
import com.mypurecloud.sdk.v2.model.AssistantQueueListing;
import java.io.IOException;
import java.util.List;

public class AgentAssistantsApi {
    private final ApiClient pcapiClient;

    public AgentAssistantsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AgentAssistantsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAssistant(String assistantId) throws IOException, ApiException {
        this.deleteAssistant(this.createDeleteAssistantRequest(assistantId));
    }

    public ApiResponse<Void> deleteAssistantWithHttpInfo(String assistantId) throws IOException {
        return this.deleteAssistant(this.createDeleteAssistantRequest(assistantId).withHttpInfo());
    }

    private DeleteAssistantRequest createDeleteAssistantRequest(String assistantId) {
        return DeleteAssistantRequest.builder().withAssistantId(assistantId).build();
    }

    public void deleteAssistant(DeleteAssistantRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAssistant(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteAssistantQueue(String assistantId, String queueId) throws IOException, ApiException {
        this.deleteAssistantQueue(this.createDeleteAssistantQueueRequest(assistantId, queueId));
    }

    public ApiResponse<Void> deleteAssistantQueueWithHttpInfo(String assistantId, String queueId) throws IOException {
        return this.deleteAssistantQueue(this.createDeleteAssistantQueueRequest(assistantId, queueId).withHttpInfo());
    }

    private DeleteAssistantQueueRequest createDeleteAssistantQueueRequest(String assistantId, String queueId) {
        return DeleteAssistantQueueRequest.builder().withAssistantId(assistantId).withQueueId(queueId).build();
    }

    public void deleteAssistantQueue(DeleteAssistantQueueRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAssistantQueue(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteAssistantQueues(String assistantId, String queueIds) throws IOException, ApiException {
        this.deleteAssistantQueues(this.createDeleteAssistantQueuesRequest(assistantId, queueIds));
    }

    public ApiResponse<Void> deleteAssistantQueuesWithHttpInfo(String assistantId, String queueIds) throws IOException {
        return this.deleteAssistantQueues(this.createDeleteAssistantQueuesRequest(assistantId, queueIds).withHttpInfo());
    }

    private DeleteAssistantQueuesRequest createDeleteAssistantQueuesRequest(String assistantId, String queueIds) {
        return DeleteAssistantQueuesRequest.builder().withAssistantId(assistantId).withQueueIds(queueIds).build();
    }

    public void deleteAssistantQueues(DeleteAssistantQueuesRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAssistantQueues(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Assistant getAssistant(String assistantId, String expand) throws IOException, ApiException {
        return this.getAssistant(this.createGetAssistantRequest(assistantId, expand));
    }

    public ApiResponse<Assistant> getAssistantWithHttpInfo(String assistantId, String expand) throws IOException {
        return this.getAssistant(this.createGetAssistantRequest(assistantId, expand).withHttpInfo());
    }

    private GetAssistantRequest createGetAssistantRequest(String assistantId, String expand) {
        return GetAssistantRequest.builder().withAssistantId(assistantId).withExpand(expand).build();
    }

    public Assistant getAssistant(GetAssistantRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Assistant> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Assistant>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Assistant> getAssistant(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Assistant>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssistantQueue getAssistantQueue(String assistantId, String queueId, String expand) throws IOException, ApiException {
        return this.getAssistantQueue(this.createGetAssistantQueueRequest(assistantId, queueId, expand));
    }

    public ApiResponse<AssistantQueue> getAssistantQueueWithHttpInfo(String assistantId, String queueId, String expand) throws IOException {
        return this.getAssistantQueue(this.createGetAssistantQueueRequest(assistantId, queueId, expand).withHttpInfo());
    }

    private GetAssistantQueueRequest createGetAssistantQueueRequest(String assistantId, String queueId, String expand) {
        return GetAssistantQueueRequest.builder().withAssistantId(assistantId).withQueueId(queueId).withExpand(expand).build();
    }

    public AssistantQueue getAssistantQueue(GetAssistantQueueRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssistantQueue> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssistantQueue>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssistantQueue> getAssistantQueue(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssistantQueue>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssistantQueueListing getAssistantQueues(String assistantId, String before, String after, String pageSize, String expand) throws IOException, ApiException {
        return this.getAssistantQueues(this.createGetAssistantQueuesRequest(assistantId, before, after, pageSize, expand));
    }

    public ApiResponse<AssistantQueueListing> getAssistantQueuesWithHttpInfo(String assistantId, String before, String after, String pageSize, String expand) throws IOException {
        return this.getAssistantQueues(this.createGetAssistantQueuesRequest(assistantId, before, after, pageSize, expand).withHttpInfo());
    }

    private GetAssistantQueuesRequest createGetAssistantQueuesRequest(String assistantId, String before, String after, String pageSize, String expand) {
        return GetAssistantQueuesRequest.builder().withAssistantId(assistantId).withBefore(before).withAfter(after).withPageSize(pageSize).withExpand(expand).build();
    }

    public AssistantQueueListing getAssistantQueues(GetAssistantQueuesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssistantQueueListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssistantQueueListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssistantQueueListing> getAssistantQueues(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssistantQueueListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssistantListing getAssistants(String before, String after, String limit, String pageSize, String name) throws IOException, ApiException {
        return this.getAssistants(this.createGetAssistantsRequest(before, after, limit, pageSize, name));
    }

    public ApiResponse<AssistantListing> getAssistantsWithHttpInfo(String before, String after, String limit, String pageSize, String name) throws IOException {
        return this.getAssistants(this.createGetAssistantsRequest(before, after, limit, pageSize, name).withHttpInfo());
    }

    private GetAssistantsRequest createGetAssistantsRequest(String before, String after, String limit, String pageSize, String name) {
        return GetAssistantsRequest.builder().withBefore(before).withAfter(after).withLimit(limit).withPageSize(pageSize).withName(name).build();
    }

    public AssistantListing getAssistants(GetAssistantsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssistantListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssistantListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssistantListing> getAssistants(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssistantListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssistantQueueListing getAssistantsQueues(String before, String after, String pageSize, String queueIds, String expand) throws IOException, ApiException {
        return this.getAssistantsQueues(this.createGetAssistantsQueuesRequest(before, after, pageSize, queueIds, expand));
    }

    public ApiResponse<AssistantQueueListing> getAssistantsQueuesWithHttpInfo(String before, String after, String pageSize, String queueIds, String expand) throws IOException {
        return this.getAssistantsQueues(this.createGetAssistantsQueuesRequest(before, after, pageSize, queueIds, expand).withHttpInfo());
    }

    private GetAssistantsQueuesRequest createGetAssistantsQueuesRequest(String before, String after, String pageSize, String queueIds, String expand) {
        return GetAssistantsQueuesRequest.builder().withBefore(before).withAfter(after).withPageSize(pageSize).withQueueIds(queueIds).withExpand(expand).build();
    }

    public AssistantQueueListing getAssistantsQueues(GetAssistantsQueuesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssistantQueueListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssistantQueueListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssistantQueueListing> getAssistantsQueues(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssistantQueueListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Assistant patchAssistant(String assistantId, Assistant body) throws IOException, ApiException {
        return this.patchAssistant(this.createPatchAssistantRequest(assistantId, body));
    }

    public ApiResponse<Assistant> patchAssistantWithHttpInfo(String assistantId, Assistant body) throws IOException {
        return this.patchAssistant(this.createPatchAssistantRequest(assistantId, body).withHttpInfo());
    }

    private PatchAssistantRequest createPatchAssistantRequest(String assistantId, Assistant body) {
        return PatchAssistantRequest.builder().withAssistantId(assistantId).withBody(body).build();
    }

    public Assistant patchAssistant(PatchAssistantRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Assistant> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Assistant>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Assistant> patchAssistant(ApiRequest<Assistant> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Assistant>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssistantQueueListing patchAssistantQueues(String assistantId, List<AssistantQueue> body) throws IOException, ApiException {
        return this.patchAssistantQueues(this.createPatchAssistantQueuesRequest(assistantId, body));
    }

    public ApiResponse<AssistantQueueListing> patchAssistantQueuesWithHttpInfo(String assistantId, List<AssistantQueue> body) throws IOException {
        return this.patchAssistantQueues(this.createPatchAssistantQueuesRequest(assistantId, body).withHttpInfo());
    }

    private PatchAssistantQueuesRequest createPatchAssistantQueuesRequest(String assistantId, List<AssistantQueue> body) {
        return PatchAssistantQueuesRequest.builder().withAssistantId(assistantId).withBody(body).build();
    }

    public AssistantQueueListing patchAssistantQueues(PatchAssistantQueuesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssistantQueueListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssistantQueueListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssistantQueueListing> patchAssistantQueues(ApiRequest<List<AssistantQueue>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssistantQueueListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Assistant postAssistants(Assistant body) throws IOException, ApiException {
        return this.postAssistants(this.createPostAssistantsRequest(body));
    }

    public ApiResponse<Assistant> postAssistantsWithHttpInfo(Assistant body) throws IOException {
        return this.postAssistants(this.createPostAssistantsRequest(body).withHttpInfo());
    }

    private PostAssistantsRequest createPostAssistantsRequest(Assistant body) {
        return PostAssistantsRequest.builder().withBody(body).build();
    }

    public Assistant postAssistants(PostAssistantsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Assistant> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Assistant>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Assistant> postAssistants(ApiRequest<Assistant> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Assistant>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AssistantQueue putAssistantQueue(String assistantId, String queueId, AssistantQueue body) throws IOException, ApiException {
        return this.putAssistantQueue(this.createPutAssistantQueueRequest(assistantId, queueId, body));
    }

    public ApiResponse<AssistantQueue> putAssistantQueueWithHttpInfo(String assistantId, String queueId, AssistantQueue body) throws IOException {
        return this.putAssistantQueue(this.createPutAssistantQueueRequest(assistantId, queueId, body).withHttpInfo());
    }

    private PutAssistantQueueRequest createPutAssistantQueueRequest(String assistantId, String queueId, AssistantQueue body) {
        return PutAssistantQueueRequest.builder().withAssistantId(assistantId).withQueueId(queueId).withBody(body).build();
    }

    public AssistantQueue putAssistantQueue(PutAssistantQueueRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AssistantQueue> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AssistantQueue>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AssistantQueue> putAssistantQueue(ApiRequest<AssistantQueue> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AssistantQueue>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

