/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.JourneyViewSchedule;
import java.util.HashMap;
import java.util.Map;

public class PostJourneyViewSchedulesRequest {
    private String viewId;
    private JourneyViewSchedule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public PostJourneyViewSchedulesRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public JourneyViewSchedule getBody() {
        return this.body;
    }

    public void setBody(JourneyViewSchedule body) {
        this.body = body;
    }

    public PostJourneyViewSchedulesRequest withBody(JourneyViewSchedule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostJourneyViewSchedulesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<JourneyViewSchedule> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for PostJourneyViewSchedulesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostJourneyViewSchedulesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/journey/views/{viewId}/schedules").withPathParameter("viewId", this.viewId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, JourneyViewSchedule body) {
        return new Builder().withRequiredParams(viewId, body);
    }

    public static class Builder {
        private final PostJourneyViewSchedulesRequest request = new PostJourneyViewSchedulesRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withBody(JourneyViewSchedule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String viewId, JourneyViewSchedule body) {
            this.request.setViewId(viewId);
            this.request.setBody(body);
            return this;
        }

        public PostJourneyViewSchedulesRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for PostJourneyViewSchedulesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostJourneyViewSchedulesRequest.");
            }
            return this.request;
        }
    }
}

