/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.OpenInboundNormalizedEvent;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsMessageInboundOpenEventRequest {
    private String integrationId;
    private OpenInboundNormalizedEvent body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public PostConversationsMessageInboundOpenEventRequest withIntegrationId(String integrationId) {
        this.setIntegrationId(integrationId);
        return this;
    }

    public OpenInboundNormalizedEvent getBody() {
        return this.body;
    }

    public void setBody(OpenInboundNormalizedEvent body) {
        this.body = body;
    }

    public PostConversationsMessageInboundOpenEventRequest withBody(OpenInboundNormalizedEvent body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsMessageInboundOpenEventRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<OpenInboundNormalizedEvent> withHttpInfo() {
        if (this.integrationId == null) {
            throw new IllegalStateException("Missing the required parameter 'integrationId' when building request for PostConversationsMessageInboundOpenEventRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsMessageInboundOpenEventRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/messages/{integrationId}/inbound/open/event").withPathParameter("integrationId", this.integrationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String integrationId, OpenInboundNormalizedEvent body) {
        return new Builder().withRequiredParams(integrationId, body);
    }

    public static class Builder {
        private final PostConversationsMessageInboundOpenEventRequest request = new PostConversationsMessageInboundOpenEventRequest();

        private Builder() {
        }

        public Builder withIntegrationId(String integrationId) {
            this.request.setIntegrationId(integrationId);
            return this;
        }

        public Builder withBody(OpenInboundNormalizedEvent body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String integrationId, OpenInboundNormalizedEvent body) {
            this.request.setIntegrationId(integrationId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsMessageInboundOpenEventRequest build() {
            if (this.request.integrationId == null) {
                throw new IllegalStateException("Missing the required parameter 'integrationId' when building request for PostConversationsMessageInboundOpenEventRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsMessageInboundOpenEventRequest.");
            }
            return this.request;
        }
    }
}

