/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CriteriaCategoryInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A criteria type that can be used in tandem with other criteria type to create queries of executionData")
public class QueryCriteria
implements Serializable {
    private CriteriaKeyEnum criteriaKey = null;
    private List<CriteriaGroupsEnum> criteriaGroups = new ArrayList<CriteriaGroupsEnum>();
    private String description = null;
    private List<String> operators = new ArrayList<String>();
    private DataTypeEnum dataType = null;
    private CriteriaCategoryInfo categoryInfo = null;

    public QueryCriteria criteriaKey(CriteriaKeyEnum criteriaKey) {
        this.criteriaKey = criteriaKey;
        return this;
    }

    @ApiModelProperty(example="null", value="The is the name of the criteria that can be queried.")
    @JsonProperty(value="criteriaKey")
    public CriteriaKeyEnum getCriteriaKey() {
        return this.criteriaKey;
    }

    public void setCriteriaKey(CriteriaKeyEnum criteriaKey) {
        this.criteriaKey = criteriaKey;
    }

    public QueryCriteria criteriaGroups(List<CriteriaGroupsEnum> criteriaGroups) {
        this.criteriaGroups = criteriaGroups;
        return this;
    }

    @ApiModelProperty(example="null", value="The executionData type that this criteria item can be used on.")
    @JsonProperty(value="criteriaGroups")
    public List<CriteriaGroupsEnum> getCriteriaGroups() {
        return this.criteriaGroups;
    }

    public void setCriteriaGroups(List<CriteriaGroupsEnum> criteriaGroups) {
        this.criteriaGroups = criteriaGroups;
    }

    public QueryCriteria description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The is the description of the criteria.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public QueryCriteria operators(List<String> operators) {
        this.operators = operators;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of operators that can be used on this criteria.")
    @JsonProperty(value="operators")
    public List<String> getOperators() {
        return this.operators;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public QueryCriteria dataType(DataTypeEnum dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of data for the criteria (string, int, etc).")
    @JsonProperty(value="dataType")
    public DataTypeEnum getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypeEnum dataType) {
        this.dataType = dataType;
    }

    public QueryCriteria categoryInfo(CriteriaCategoryInfo categoryInfo) {
        this.categoryInfo = categoryInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="A logical grouping and display order for this item.")
    @JsonProperty(value="categoryInfo")
    public CriteriaCategoryInfo getCategoryInfo() {
        return this.categoryInfo;
    }

    public void setCategoryInfo(CriteriaCategoryInfo categoryInfo) {
        this.categoryInfo = categoryInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryCriteria queryCriteria = (QueryCriteria)o;
        return Objects.equals((Object)this.criteriaKey, (Object)queryCriteria.criteriaKey) && Objects.equals(this.criteriaGroups, queryCriteria.criteriaGroups) && Objects.equals(this.description, queryCriteria.description) && Objects.equals(this.operators, queryCriteria.operators) && Objects.equals((Object)this.dataType, (Object)queryCriteria.dataType) && Objects.equals(this.categoryInfo, queryCriteria.categoryInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.criteriaKey, this.criteriaGroups, this.description, this.operators, this.dataType, this.categoryInfo});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryCriteria {\n");
        sb.append("    criteriaKey: ").append(this.toIndentedString((Object)this.criteriaKey)).append("\n");
        sb.append("    criteriaGroups: ").append(this.toIndentedString(this.criteriaGroups)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    operators: ").append(this.toIndentedString(this.operators)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString((Object)this.dataType)).append("\n");
        sb.append("    categoryInfo: ").append(this.toIndentedString(this.categoryInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CriteriaKeyEnumDeserializer.class)
    public static enum CriteriaKeyEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FLOWSTARTDATETIME("FlowStartDateTime"),
        FLOWENDDATETIME("FlowEndDateTime"),
        CONVERSATIONID("ConversationId"),
        WORKITEMID("WorkitemId"),
        FLOWTYPE("FlowType"),
        FLOWID("FlowId"),
        FLOWERRORREASON("FlowErrorReason"),
        FLOWWARNINGREASON("FlowWarningReason"),
        FLOWALTERNATEEXECUTIONID("FlowAlternateExecutionId"),
        FLOWOBJECTEXECUTIONID("FlowObjectExecutionId"),
        FLOWACTIONID("FlowActionId"),
        FLOWACTIONTYPE("FlowActionType"),
        FLOWACTIONOUTPUTPATHID("FlowActionOutputPathId"),
        FLOWACTIONOUTPUTPATHNAME("FlowActionOutputPathName"),
        FLOWACTIONIDOUTPUTPATHID("FlowActionIdOutputPathId"),
        FLOWACTIONIDOUTPUTPATHNAME("FlowActionIdOutputPathName"),
        FLOWACTIONTYPEOUTPUTPATHID("FlowActionTypeOutputPathId"),
        FLOWACTIONTYPEOUTPUTPATHNAME("FlowActionTypeOutputPathName"),
        BOTID("BotId"),
        BOTERRORREASON("BotErrorReason"),
        BOTFLOWEXECUTIONID("BotFlowExecutionId"),
        BOTOBJECTEXECUTIONID("BotObjectExecutionId");

        private String value;

        private CriteriaKeyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CriteriaKeyEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CriteriaKeyEnum value : CriteriaKeyEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CriteriaKeyEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DataTypeEnumDeserializer.class)
    public static enum DataTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("string"),
        GUID("guid"),
        DATETIME("dateTime");

        private String value;

        private DataTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DataTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DataTypeEnum value : DataTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DataTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DataTypeEnumDeserializer
    extends StdDeserializer<DataTypeEnum> {
        public DataTypeEnumDeserializer() {
            super(DataTypeEnumDeserializer.class);
        }

        public DataTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DataTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=CriteriaGroupsEnumDeserializer.class)
    public static enum CriteriaGroupsEnum {
        FLOW("flow"),
        BOT("bot");

        private String value;

        private CriteriaGroupsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CriteriaGroupsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CriteriaGroupsEnum value : CriteriaGroupsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CriteriaGroupsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CriteriaGroupsEnumDeserializer
    extends StdDeserializer<CriteriaGroupsEnum> {
        public CriteriaGroupsEnumDeserializer() {
            super(CriteriaGroupsEnumDeserializer.class);
        }

        public CriteriaGroupsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CriteriaGroupsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class CriteriaKeyEnumDeserializer
    extends StdDeserializer<CriteriaKeyEnum> {
        public CriteriaKeyEnumDeserializer() {
            super(CriteriaKeyEnumDeserializer.class);
        }

        public CriteriaKeyEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CriteriaKeyEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

