/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeGuestDocumentCopy
implements Serializable {
    private String documentVariationId = null;
    private String documentVersionId = null;
    private String searchId = null;
    private QueryTypeEnum queryType = null;
    private SurfacingMethodEnum surfacingMethod = null;
    private String sessionId = null;
    private KnowledgeGuestSearchClientApplication application = null;

    public KnowledgeGuestDocumentCopy documentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The variation of the document whose content was copied.")
    @JsonProperty(value="documentVariationId")
    public String getDocumentVariationId() {
        return this.documentVariationId;
    }

    public void setDocumentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
    }

    public KnowledgeGuestDocumentCopy documentVersionId(String documentVersionId) {
        this.documentVersionId = documentVersionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The version of the document whose content was copied.")
    @JsonProperty(value="documentVersionId")
    public String getDocumentVersionId() {
        return this.documentVersionId;
    }

    public void setDocumentVersionId(String documentVersionId) {
        this.documentVersionId = documentVersionId;
    }

    public KnowledgeGuestDocumentCopy searchId(String searchId) {
        this.searchId = searchId;
        return this;
    }

    @ApiModelProperty(example="null", value="The search that surfaced the document whose content was copied.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    public void setSearchId(String searchId) {
        this.searchId = searchId;
    }

    public KnowledgeGuestDocumentCopy queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that surfaced the document.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeGuestDocumentCopy surfacingMethod(SurfacingMethodEnum surfacingMethod) {
        this.surfacingMethod = surfacingMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.")
    @JsonProperty(value="surfacingMethod")
    public SurfacingMethodEnum getSurfacingMethod() {
        return this.surfacingMethod;
    }

    public void setSurfacingMethod(SurfacingMethodEnum surfacingMethod) {
        this.surfacingMethod = surfacingMethod;
    }

    @ApiModelProperty(example="null", value="Knowledge session ID.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @ApiModelProperty(example="null", value="The client application in which the document content was copied.")
    @JsonProperty(value="application")
    public KnowledgeGuestSearchClientApplication getApplication() {
        return this.application;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeGuestDocumentCopy knowledgeGuestDocumentCopy = (KnowledgeGuestDocumentCopy)o;
        return Objects.equals(this.documentVariationId, knowledgeGuestDocumentCopy.documentVariationId) && Objects.equals(this.documentVersionId, knowledgeGuestDocumentCopy.documentVersionId) && Objects.equals(this.searchId, knowledgeGuestDocumentCopy.searchId) && Objects.equals((Object)this.queryType, (Object)knowledgeGuestDocumentCopy.queryType) && Objects.equals((Object)this.surfacingMethod, (Object)knowledgeGuestDocumentCopy.surfacingMethod) && Objects.equals(this.sessionId, knowledgeGuestDocumentCopy.sessionId) && Objects.equals(this.application, knowledgeGuestDocumentCopy.application);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documentVariationId, this.documentVersionId, this.searchId, this.queryType, this.surfacingMethod, this.sessionId, this.application});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeGuestDocumentCopy {\n");
        sb.append("    documentVariationId: ").append(this.toIndentedString(this.documentVariationId)).append("\n");
        sb.append("    documentVersionId: ").append(this.toIndentedString(this.documentVersionId)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    surfacingMethod: ").append(this.toIndentedString((Object)this.surfacingMethod)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        AUTOSEARCH("AutoSearch"),
        CATEGORY("Category"),
        MANUALSEARCH("ManualSearch"),
        RECOMMENDATION("Recommendation"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SurfacingMethodEnumDeserializer.class)
    public static enum SurfacingMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        SNIPPET("Snippet"),
        HIGHLIGHT("Highlight");

        private String value;

        private SurfacingMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SurfacingMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SurfacingMethodEnum value : SurfacingMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SurfacingMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SurfacingMethodEnumDeserializer
    extends StdDeserializer<SurfacingMethodEnum> {
        public SurfacingMethodEnumDeserializer() {
            super(SurfacingMethodEnumDeserializer.class);
        }

        public SurfacingMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SurfacingMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

