/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentGuestSearchResult;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeDocumentGuestSearch
implements Serializable {
    private String query = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private String searchId = null;
    private Integer total = null;
    private Integer pageCount = null;
    private QueryTypeEnum queryType = null;
    private String sessionId = null;
    private List<KnowledgeDocumentGuestSearchResult> results = new ArrayList<KnowledgeDocumentGuestSearchResult>();

    public KnowledgeDocumentGuestSearch query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KnowledgeDocumentGuestSearch pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentGuestSearch pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the search.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    @ApiModelProperty(example="null", value="The total number of documents matching the query.")
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(example="null", value="Number of pages returned in the result calculated according to the pageSize and the total")
    @JsonProperty(value="pageCount")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public KnowledgeDocumentGuestSearch queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that initiates the search.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    @ApiModelProperty(example="null", value="Session ID of the search.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @ApiModelProperty(example="null", value="Documents that matched the search query.")
    @JsonProperty(value="results")
    public List<KnowledgeDocumentGuestSearchResult> getResults() {
        return this.results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentGuestSearch knowledgeDocumentGuestSearch = (KnowledgeDocumentGuestSearch)o;
        return Objects.equals(this.query, knowledgeDocumentGuestSearch.query) && Objects.equals(this.pageSize, knowledgeDocumentGuestSearch.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentGuestSearch.pageNumber) && Objects.equals(this.searchId, knowledgeDocumentGuestSearch.searchId) && Objects.equals(this.total, knowledgeDocumentGuestSearch.total) && Objects.equals(this.pageCount, knowledgeDocumentGuestSearch.pageCount) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentGuestSearch.queryType) && Objects.equals(this.sessionId, knowledgeDocumentGuestSearch.sessionId) && Objects.equals(this.results, knowledgeDocumentGuestSearch.results);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.pageSize, this.pageNumber, this.searchId, this.total, this.pageCount, this.queryType, this.sessionId, this.results});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentGuestSearch {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTOSEARCH("AutoSearch"),
        MANUALSEARCH("ManualSearch"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

