/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeAggregateQueryFilter;
import com.mypurecloud.sdk.v2.model.KnowledgeAggregationView;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeAggregationQuery
implements Serializable {
    private String interval = null;
    private String granularity = null;
    private String timeZone = null;
    private List<GroupByEnum> groupBy = new ArrayList<GroupByEnum>();
    private KnowledgeAggregateQueryFilter filter = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    private Boolean flattenMultivaluedDimensions = null;
    private List<KnowledgeAggregationView> views = new ArrayList<KnowledgeAggregationView>();
    private AlternateTimeDimensionEnum alternateTimeDimension = null;
    private QueryTypeEnum queryType = null;
    private Integer limit = null;

    public KnowledgeAggregationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public KnowledgeAggregationQuery granularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="granularity")
    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public KnowledgeAggregationQuery timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public KnowledgeAggregationQuery groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public KnowledgeAggregationQuery filter(KnowledgeAggregateQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public KnowledgeAggregateQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(KnowledgeAggregateQueryFilter filter) {
        this.filter = filter;
    }

    public KnowledgeAggregationQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like a SQL SELECT clause. Only named metrics will be retrieved.")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public KnowledgeAggregationQuery flattenMultivaluedDimensions(Boolean flattenMultivaluedDimensions) {
        this.flattenMultivaluedDimensions = flattenMultivaluedDimensions;
        return this;
    }

    @ApiModelProperty(example="null", value="Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')")
    @JsonProperty(value="flattenMultivaluedDimensions")
    public Boolean getFlattenMultivaluedDimensions() {
        return this.flattenMultivaluedDimensions;
    }

    public void setFlattenMultivaluedDimensions(Boolean flattenMultivaluedDimensions) {
        this.flattenMultivaluedDimensions = flattenMultivaluedDimensions;
    }

    public KnowledgeAggregationQuery views(List<KnowledgeAggregationView> views) {
        this.views = views;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom derived metric views")
    @JsonProperty(value="views")
    public List<KnowledgeAggregationView> getViews() {
        return this.views;
    }

    public void setViews(List<KnowledgeAggregationView> views) {
        this.views = views;
    }

    public KnowledgeAggregationQuery alternateTimeDimension(AlternateTimeDimensionEnum alternateTimeDimension) {
        this.alternateTimeDimension = alternateTimeDimension;
        return this;
    }

    @ApiModelProperty(example="null", value="Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.")
    @JsonProperty(value="alternateTimeDimension")
    public AlternateTimeDimensionEnum getAlternateTimeDimension() {
        return this.alternateTimeDimension;
    }

    public void setAlternateTimeDimension(AlternateTimeDimensionEnum alternateTimeDimension) {
        this.alternateTimeDimension = alternateTimeDimension;
    }

    public KnowledgeAggregationQuery queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="Query type to use. Use groupBy for all matching results, and topN for just top N results for the requested metric (group by exactly 1 dimension)")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeAggregationQuery limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(example="null", value="How many results you want in the topN list. Only applicable for topN query type.")
    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeAggregationQuery knowledgeAggregationQuery = (KnowledgeAggregationQuery)o;
        return Objects.equals(this.interval, knowledgeAggregationQuery.interval) && Objects.equals(this.granularity, knowledgeAggregationQuery.granularity) && Objects.equals(this.timeZone, knowledgeAggregationQuery.timeZone) && Objects.equals(this.groupBy, knowledgeAggregationQuery.groupBy) && Objects.equals(this.filter, knowledgeAggregationQuery.filter) && Objects.equals(this.metrics, knowledgeAggregationQuery.metrics) && Objects.equals(this.flattenMultivaluedDimensions, knowledgeAggregationQuery.flattenMultivaluedDimensions) && Objects.equals(this.views, knowledgeAggregationQuery.views) && Objects.equals((Object)this.alternateTimeDimension, (Object)knowledgeAggregationQuery.alternateTimeDimension) && Objects.equals((Object)this.queryType, (Object)knowledgeAggregationQuery.queryType) && Objects.equals(this.limit, knowledgeAggregationQuery.limit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.granularity, this.timeZone, this.groupBy, this.filter, this.metrics, this.flattenMultivaluedDimensions, this.views, this.alternateTimeDimension, this.queryType, this.limit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeAggregationQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString(this.granularity)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    flattenMultivaluedDimensions: ").append(this.toIndentedString(this.flattenMultivaluedDimensions)).append("\n");
        sb.append("    views: ").append(this.toIndentedString(this.views)).append("\n");
        sb.append("    alternateTimeDimension: ").append(this.toIndentedString((Object)this.alternateTimeDimension)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlternateTimeDimensionEnumDeserializer.class)
    public static enum AlternateTimeDimensionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EVENTTIME("eventTime");

        private String value;

        private AlternateTimeDimensionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlternateTimeDimensionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlternateTimeDimensionEnum value : AlternateTimeDimensionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlternateTimeDimensionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GROUPBY("groupBy"),
        TOPN("topN");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AlternateTimeDimensionEnumDeserializer
    extends StdDeserializer<AlternateTimeDimensionEnum> {
        public AlternateTimeDimensionEnumDeserializer() {
            super(AlternateTimeDimensionEnumDeserializer.class);
        }

        public AlternateTimeDimensionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlternateTimeDimensionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        NDISTINCTKNOWLEDGESESSIONS("nDistinctKnowledgeSessions"),
        NKNOWLEDGEDOCUMENTCOPIED("nKnowledgeDocumentCopied"),
        NKNOWLEDGEDOCUMENTFEEDBACK("nKnowledgeDocumentFeedback"),
        NKNOWLEDGEDOCUMENTPRESENTED("nKnowledgeDocumentPresented"),
        NKNOWLEDGEDOCUMENTSURFACED("nKnowledgeDocumentSurfaced"),
        NKNOWLEDGEDOCUMENTVIEWED("nKnowledgeDocumentViewed"),
        NKNOWLEDGESEARCH("nKnowledgeSearch"),
        NKNOWLEDGESEARCHANSWERED("nKnowledgeSearchAnswered"),
        NKNOWLEDGESEARCHFEEDBACK("nKnowledgeSearchFeedback"),
        NKNOWLEDGESEARCHUNANSWERED("nKnowledgeSearchUnanswered"),
        NKNOWLEDGESESSIONS("nKnowledgeSessions"),
        OKNOWLEDGEDOCUMENTQUERY("oKnowledgeDocumentQuery"),
        OKNOWLEDGEDOCUMENTQUERYSELFSERVED("oKnowledgeDocumentQuerySelfServed"),
        OKNOWLEDGESEARCH("oKnowledgeSearch");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=GroupByEnumDeserializer.class)
    public static enum GroupByEnum {
        AGENTASSISTANTID("agentAssistantId"),
        APPDEPLOYMENTID("appDeploymentId"),
        APPTYPE("appType"),
        CONVERSATIONCHANNELTYPE("conversationChannelType"),
        CONVERSATIONID("conversationId"),
        DOCUMENTENGAGEMENTTYPE("documentEngagementType"),
        EXTERNALCONTACTID("externalContactId"),
        FEEDBACKCATEGORY("feedbackCategory"),
        FEEDBACKID("feedbackId"),
        FEEDBACKRATING("feedbackRating"),
        FEEDBACKRATINGTYPE("feedbackRatingType"),
        FEEDBACKRATINGVALUE("feedbackRatingValue"),
        FEEDBACKREASON("feedbackReason"),
        FEEDBACKTYPE("feedbackType"),
        HASCOMMENT("hasComment"),
        HASSEARCH("hasSearch"),
        KNOWLEDGEBASEDOCUMENTID("knowledgeBaseDocumentId"),
        KNOWLEDGEBASEDOCUMENTVARIATIONID("knowledgeBaseDocumentVariationId"),
        KNOWLEDGEBASEDOCUMENTVERSIONID("knowledgeBaseDocumentVersionId"),
        KNOWLEDGEBASEID("knowledgeBaseId"),
        LANGUAGECODE("languageCode"),
        MEDIATYPE("mediaType"),
        PRESENTEDDOCUMENTSCOUNT("presentedDocumentsCount"),
        QUERYTYPE("queryType"),
        QUEUEID("queueId"),
        SEARCHID("searchId"),
        SEARCHQUERY("searchQuery"),
        SELFSERVED("selfServed"),
        SESSIONID("sessionId"),
        SURFACINGMETHOD("surfacingMethod"),
        USERID("userId");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByEnumDeserializer
    extends StdDeserializer<GroupByEnum> {
        public GroupByEnumDeserializer() {
            super(GroupByEnumDeserializer.class);
        }

        public GroupByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

