/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ExternalMetricDefinitionCreateRequest
implements Serializable {
    private String name = null;
    private UnitEnum unit = null;
    private String unitDefinition = null;
    private Integer precision = null;
    private DefaultObjectiveTypeEnum defaultObjectiveType = null;
    private Boolean enabled = null;

    public ExternalMetricDefinitionCreateRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the External Metric Definition")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExternalMetricDefinitionCreateRequest unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The unit of the External Metric Definition")
    @JsonProperty(value="unit")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public ExternalMetricDefinitionCreateRequest unitDefinition(String unitDefinition) {
        this.unitDefinition = unitDefinition;
        return this;
    }

    @ApiModelProperty(example="null", value="The unit definition of the External Metric Definition")
    @JsonProperty(value="unitDefinition")
    public String getUnitDefinition() {
        return this.unitDefinition;
    }

    public void setUnitDefinition(String unitDefinition) {
        this.unitDefinition = unitDefinition;
    }

    public ExternalMetricDefinitionCreateRequest precision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The decimal precision of the External Metric Definition. Must be at least 0 and at most 5")
    @JsonProperty(value="precision")
    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public ExternalMetricDefinitionCreateRequest defaultObjectiveType(DefaultObjectiveTypeEnum defaultObjectiveType) {
        this.defaultObjectiveType = defaultObjectiveType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The default objective type of the External Metric Definition")
    @JsonProperty(value="defaultObjectiveType")
    public DefaultObjectiveTypeEnum getDefaultObjectiveType() {
        return this.defaultObjectiveType;
    }

    public void setDefaultObjectiveType(DefaultObjectiveTypeEnum defaultObjectiveType) {
        this.defaultObjectiveType = defaultObjectiveType;
    }

    public ExternalMetricDefinitionCreateRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="True if the External Metric Definition is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricDefinitionCreateRequest externalMetricDefinitionCreateRequest = (ExternalMetricDefinitionCreateRequest)o;
        return Objects.equals(this.name, externalMetricDefinitionCreateRequest.name) && Objects.equals((Object)this.unit, (Object)externalMetricDefinitionCreateRequest.unit) && Objects.equals(this.unitDefinition, externalMetricDefinitionCreateRequest.unitDefinition) && Objects.equals(this.precision, externalMetricDefinitionCreateRequest.precision) && Objects.equals((Object)this.defaultObjectiveType, (Object)externalMetricDefinitionCreateRequest.defaultObjectiveType) && Objects.equals(this.enabled, externalMetricDefinitionCreateRequest.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.unit, this.unitDefinition, this.precision, this.defaultObjectiveType, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalMetricDefinitionCreateRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    unitDefinition: ").append(this.toIndentedString(this.unitDefinition)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    defaultObjectiveType: ").append(this.toIndentedString((Object)this.defaultObjectiveType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitEnumDeserializer.class)
    public static enum UnitEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SECONDS("Seconds"),
        PERCENT("Percent"),
        NUMBER("Number"),
        CURRENCY("Currency");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitEnum value : UnitEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DefaultObjectiveTypeEnumDeserializer.class)
    public static enum DefaultObjectiveTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIGHERISBETTER("HigherIsBetter"),
        LOWERISBETTER("LowerIsBetter"),
        TARGETAREA("TargetArea");

        private String value;

        private DefaultObjectiveTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DefaultObjectiveTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DefaultObjectiveTypeEnum value : DefaultObjectiveTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DefaultObjectiveTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DefaultObjectiveTypeEnumDeserializer
    extends StdDeserializer<DefaultObjectiveTypeEnum> {
        public DefaultObjectiveTypeEnumDeserializer() {
            super(DefaultObjectiveTypeEnumDeserializer.class);
        }

        public DefaultObjectiveTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DefaultObjectiveTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class UnitEnumDeserializer
    extends StdDeserializer<UnitEnum> {
        public UnitEnumDeserializer() {
            super(UnitEnumDeserializer.class);
        }

        public UnitEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

