/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EmailInitialConfiguration
implements Serializable {
    private String to = null;
    private String from = null;
    private List<String> cc = new ArrayList<String>();
    private List<String> bcc = new ArrayList<String>();
    private String subject = null;
    private String previousEmailId = null;
    private Boolean held = null;
    private Boolean alerting = null;
    private Boolean inbound = null;
    private String invitedBy = null;
    private Map<String, String> additionalInfo = null;

    public EmailInitialConfiguration to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="An email address that this email is to.")
    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public EmailInitialConfiguration from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="An email address that this email is from.")
    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public EmailInitialConfiguration cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    @ApiModelProperty(example="null", value="An email addresses that this email is carbon copied to.")
    @JsonProperty(value="cc")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public EmailInitialConfiguration bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    @ApiModelProperty(example="null", value="An email addresses that this email is blind carbon copied to.")
    @JsonProperty(value="bcc")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public EmailInitialConfiguration subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject for this email.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailInitialConfiguration previousEmailId(String previousEmailId) {
        this.previousEmailId = previousEmailId;
        return this;
    }

    @ApiModelProperty(example="null", value="UUID identifying the most recent previous email communication ID from the same participant on this email conversation. Will be null if this is a new participant.")
    @JsonProperty(value="previousEmailId")
    public String getPreviousEmailId() {
        return this.previousEmailId;
    }

    public void setPreviousEmailId(String previousEmailId) {
        this.previousEmailId = previousEmailId;
    }

    public EmailInitialConfiguration held(Boolean held) {
        this.held = held;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that this communication's initial state is held.")
    @JsonProperty(value="held")
    public Boolean getHeld() {
        return this.held;
    }

    public void setHeld(Boolean held) {
        this.held = held;
    }

    public EmailInitialConfiguration alerting(Boolean alerting) {
        this.alerting = alerting;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.")
    @JsonProperty(value="alerting")
    public Boolean getAlerting() {
        return this.alerting;
    }

    public void setAlerting(Boolean alerting) {
        this.alerting = alerting;
    }

    public EmailInitialConfiguration inbound(Boolean inbound) {
        this.inbound = inbound;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.")
    @JsonProperty(value="inbound")
    public Boolean getInbound() {
        return this.inbound;
    }

    public void setInbound(Boolean inbound) {
        this.inbound = inbound;
    }

    public EmailInitialConfiguration invitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.")
    @JsonProperty(value="invitedBy")
    public String getInvitedBy() {
        return this.invitedBy;
    }

    public void setInvitedBy(String invitedBy) {
        this.invitedBy = invitedBy;
    }

    public EmailInitialConfiguration additionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.")
    @JsonProperty(value="additionalInfo")
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailInitialConfiguration emailInitialConfiguration = (EmailInitialConfiguration)o;
        return Objects.equals(this.to, emailInitialConfiguration.to) && Objects.equals(this.from, emailInitialConfiguration.from) && Objects.equals(this.cc, emailInitialConfiguration.cc) && Objects.equals(this.bcc, emailInitialConfiguration.bcc) && Objects.equals(this.subject, emailInitialConfiguration.subject) && Objects.equals(this.previousEmailId, emailInitialConfiguration.previousEmailId) && Objects.equals(this.held, emailInitialConfiguration.held) && Objects.equals(this.alerting, emailInitialConfiguration.alerting) && Objects.equals(this.inbound, emailInitialConfiguration.inbound) && Objects.equals(this.invitedBy, emailInitialConfiguration.invitedBy) && Objects.equals(this.additionalInfo, emailInitialConfiguration.additionalInfo);
    }

    public int hashCode() {
        return Objects.hash(this.to, this.from, this.cc, this.bcc, this.subject, this.previousEmailId, this.held, this.alerting, this.inbound, this.invitedBy, this.additionalInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailInitialConfiguration {\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    previousEmailId: ").append(this.toIndentedString(this.previousEmailId)).append("\n");
        sb.append("    held: ").append(this.toIndentedString(this.held)).append("\n");
        sb.append("    alerting: ").append(this.toIndentedString(this.alerting)).append("\n");
        sb.append("    inbound: ").append(this.toIndentedString(this.inbound)).append("\n");
        sb.append("    invitedBy: ").append(this.toIndentedString(this.invitedBy)).append("\n");
        sb.append("    additionalInfo: ").append(this.toIndentedString(this.additionalInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

