/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DocumentBodyRequest;
import com.mypurecloud.sdk.v2.model.DocumentVariationContext;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class DocumentVariationRequest
implements Serializable {
    private String id = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private AddressableEntityRef documentVersion = null;
    private List<DocumentVariationContext> contexts = new ArrayList<DocumentVariationContext>();
    private KnowledgeDocumentReference document = null;
    private Integer priority = null;
    private String name = null;
    private DocumentBodyRequest body = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the variation.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The creation date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The last modification date-time for the document variation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public DocumentVariationRequest documentVersion(AddressableEntityRef documentVersion) {
        this.documentVersion = documentVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the document.")
    @JsonProperty(value="documentVersion")
    public AddressableEntityRef getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(AddressableEntityRef documentVersion) {
        this.documentVersion = documentVersion;
    }

    public DocumentVariationRequest contexts(List<DocumentVariationContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The context values associated with the variation.")
    @JsonProperty(value="contexts")
    public List<DocumentVariationContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<DocumentVariationContext> contexts) {
        this.contexts = contexts;
    }

    @ApiModelProperty(example="null", value="The reference to document to which the variation is associated.")
    @JsonProperty(value="document")
    public KnowledgeDocumentReference getDocument() {
        return this.document;
    }

    public DocumentVariationRequest priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the variation.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public DocumentVariationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the variation.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DocumentVariationRequest body(DocumentBodyRequest body) {
        this.body = body;
        return this;
    }

    @ApiModelProperty(example="null", value="The content for the variation.")
    @JsonProperty(value="body")
    public DocumentBodyRequest getBody() {
        return this.body;
    }

    public void setBody(DocumentBodyRequest body) {
        this.body = body;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentVariationRequest documentVariationRequest = (DocumentVariationRequest)o;
        return Objects.equals(this.id, documentVariationRequest.id) && Objects.equals(this.dateCreated, documentVariationRequest.dateCreated) && Objects.equals(this.dateModified, documentVariationRequest.dateModified) && Objects.equals(this.documentVersion, documentVariationRequest.documentVersion) && Objects.equals(this.contexts, documentVariationRequest.contexts) && Objects.equals(this.document, documentVariationRequest.document) && Objects.equals(this.priority, documentVariationRequest.priority) && Objects.equals(this.name, documentVariationRequest.name) && Objects.equals(this.body, documentVariationRequest.body) && Objects.equals(this.selfUri, documentVariationRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dateCreated, this.dateModified, this.documentVersion, this.contexts, this.document, this.priority, this.name, this.body, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentVariationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    documentVersion: ").append(this.toIndentedString(this.documentVersion)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

