/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class BotSearchResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private BotTypeEnum botType = null;
    private String description = null;
    private String selfUri = null;

    public BotSearchResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the bot")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BotSearchResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the bot")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BotSearchResponse botType(BotTypeEnum botType) {
        this.botType = botType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The provider of the bot")
    @JsonProperty(value="botType")
    public BotTypeEnum getBotType() {
        return this.botType;
    }

    public void setBotType(BotTypeEnum botType) {
        this.botType = botType;
    }

    public BotSearchResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the bot")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BotSearchResponse botSearchResponse = (BotSearchResponse)o;
        return Objects.equals(this.id, botSearchResponse.id) && Objects.equals(this.name, botSearchResponse.name) && Objects.equals((Object)this.botType, (Object)botSearchResponse.botType) && Objects.equals(this.description, botSearchResponse.description) && Objects.equals(this.selfUri, botSearchResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.botType, this.description, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BotSearchResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    botType: ").append(this.toIndentedString((Object)this.botType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=BotTypeEnumDeserializer.class)
    public static enum BotTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENESYSBOTCONNECTOR("GenesysBotConnector"),
        GENESYSDIALOGENGINE("GenesysDialogEngine"),
        AMAZONLEX("AmazonLex"),
        GOOGLEDIALOGFLOWES("GoogleDialogFlowES"),
        GOOGLEDIALOGFLOWCX("GoogleDialogFlowCX"),
        NUANCEDLG("NuanceDlg"),
        GENESYSBOTFLOW("GenesysBotFlow"),
        GENESYSDIGITALBOTFLOW("GenesysDigitalBotFlow"),
        GENESYSVOICESURVEYFLOW("GenesysVoiceSurveyFlow");

        private String value;

        private BotTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BotTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (BotTypeEnum value : BotTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return BotTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BotTypeEnumDeserializer
    extends StdDeserializer<BotTypeEnum> {
        public BotTypeEnumDeserializer() {
            super(BotTypeEnumDeserializer.class);
        }

        public BotTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return BotTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

