/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DocumentVariationRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseDocumentVariationRequest {
    private String documentVariationId;
    private String documentId;
    private String knowledgeBaseId;
    private DocumentVariationRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDocumentVariationId() {
        return this.documentVariationId;
    }

    public void setDocumentVariationId(String documentVariationId) {
        this.documentVariationId = documentVariationId;
    }

    public PatchKnowledgeKnowledgebaseDocumentVariationRequest withDocumentVariationId(String documentVariationId) {
        this.setDocumentVariationId(documentVariationId);
        return this;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public PatchKnowledgeKnowledgebaseDocumentVariationRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseDocumentVariationRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public DocumentVariationRequest getBody() {
        return this.body;
    }

    public void setBody(DocumentVariationRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseDocumentVariationRequest withBody(DocumentVariationRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseDocumentVariationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DocumentVariationRequest> withHttpInfo() {
        if (this.documentVariationId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentVariationId' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
        }
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
        }
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/documents/{documentId}/variations/{documentVariationId}").withPathParameter("documentVariationId", this.documentVariationId).withPathParameter("documentId", this.documentId).withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String documentVariationId, String documentId, String knowledgeBaseId, DocumentVariationRequest body) {
        return new Builder().withRequiredParams(documentVariationId, documentId, knowledgeBaseId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseDocumentVariationRequest request = new PatchKnowledgeKnowledgebaseDocumentVariationRequest();

        private Builder() {
        }

        public Builder withDocumentVariationId(String documentVariationId) {
            this.request.setDocumentVariationId(documentVariationId);
            return this;
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withBody(DocumentVariationRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String documentVariationId, String documentId, String knowledgeBaseId, DocumentVariationRequest body) {
            this.request.setDocumentVariationId(documentVariationId);
            this.request.setDocumentId(documentId);
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseDocumentVariationRequest build() {
            if (this.request.documentVariationId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentVariationId' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
            }
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
            }
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseDocumentVariationRequest.");
            }
            return this.request;
        }
    }
}

