/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetQualityCalibrationRequest {
    private String calibrationId;
    private String calibratorId;
    private String conversationId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCalibrationId() {
        return this.calibrationId;
    }

    public void setCalibrationId(String calibrationId) {
        this.calibrationId = calibrationId;
    }

    public GetQualityCalibrationRequest withCalibrationId(String calibrationId) {
        this.setCalibrationId(calibrationId);
        return this;
    }

    public String getCalibratorId() {
        return this.calibratorId;
    }

    public void setCalibratorId(String calibratorId) {
        this.calibratorId = calibratorId;
    }

    public GetQualityCalibrationRequest withCalibratorId(String calibratorId) {
        this.setCalibratorId(calibratorId);
        return this;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetQualityCalibrationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetQualityCalibrationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.calibrationId == null) {
            throw new IllegalStateException("Missing the required parameter 'calibrationId' when building request for GetQualityCalibrationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/quality/calibrations/{calibrationId}").withPathParameter("calibrationId", this.calibrationId).withQueryParameters("calibratorId", "", this.calibratorId).withQueryParameters("conversationId", "", this.conversationId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String calibrationId) {
        return new Builder().withRequiredParams(calibrationId);
    }

    public static class Builder {
        private final GetQualityCalibrationRequest request = new GetQualityCalibrationRequest();

        private Builder() {
        }

        public Builder withCalibrationId(String calibrationId) {
            this.request.setCalibrationId(calibrationId);
            return this;
        }

        public Builder withCalibratorId(String calibratorId) {
            this.request.setCalibratorId(calibratorId);
            return this;
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withRequiredParams(String calibrationId) {
            this.request.setCalibrationId(calibrationId);
            return this;
        }

        public GetQualityCalibrationRequest build() {
            if (this.request.calibrationId == null) {
                throw new IllegalStateException("Missing the required parameter 'calibrationId' when building request for GetQualityCalibrationRequest.");
            }
            return this.request;
        }
    }
}

