/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneyViewVersionChartRequest {
    private String viewId;
    private String journeyViewVersion;
    private String chartId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public GetJourneyViewVersionChartRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getJourneyViewVersion() {
        return this.journeyViewVersion;
    }

    public void setJourneyViewVersion(String journeyViewVersion) {
        this.journeyViewVersion = journeyViewVersion;
    }

    public GetJourneyViewVersionChartRequest withJourneyViewVersion(String journeyViewVersion) {
        this.setJourneyViewVersion(journeyViewVersion);
        return this;
    }

    public String getChartId() {
        return this.chartId;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public GetJourneyViewVersionChartRequest withChartId(String chartId) {
        this.setChartId(chartId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneyViewVersionChartRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionChartRequest.");
        }
        if (this.journeyViewVersion == null) {
            throw new IllegalStateException("Missing the required parameter 'journeyViewVersion' when building request for GetJourneyViewVersionChartRequest.");
        }
        if (this.chartId == null) {
            throw new IllegalStateException("Missing the required parameter 'chartId' when building request for GetJourneyViewVersionChartRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/views/{viewId}/versions/{journeyViewVersion}/charts/{chartId}").withPathParameter("viewId", this.viewId).withPathParameter("journeyViewVersion", this.journeyViewVersion).withPathParameter("chartId", this.chartId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String journeyViewVersion, String chartId) {
        return new Builder().withRequiredParams(viewId, journeyViewVersion, chartId);
    }

    public static class Builder {
        private final GetJourneyViewVersionChartRequest request = new GetJourneyViewVersionChartRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withJourneyViewVersion(String journeyViewVersion) {
            this.request.setJourneyViewVersion(journeyViewVersion);
            return this;
        }

        public Builder withChartId(String chartId) {
            this.request.setChartId(chartId);
            return this;
        }

        public Builder withRequiredParams(String viewId, String journeyViewVersion, String chartId) {
            this.request.setViewId(viewId);
            this.request.setJourneyViewVersion(journeyViewVersion);
            this.request.setChartId(chartId);
            return this;
        }

        public GetJourneyViewVersionChartRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionChartRequest.");
            }
            if (this.request.journeyViewVersion == null) {
                throw new IllegalStateException("Missing the required parameter 'journeyViewVersion' when building request for GetJourneyViewVersionChartRequest.");
            }
            if (this.request.chartId == null) {
                throw new IllegalStateException("Missing the required parameter 'chartId' when building request for GetJourneyViewVersionChartRequest.");
            }
            return this.request;
        }
    }
}

