/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SalesforceSettings
implements Serializable {
    private ChannelEnum channel = null;
    private String language = null;
    private List<String> categories = new ArrayList<String>();

    public SalesforceSettings channel(ChannelEnum channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter source by channel.")
    @JsonProperty(value="channel")
    public ChannelEnum getChannel() {
        return this.channel;
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public SalesforceSettings language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter source by language.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public SalesforceSettings categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter source by categories.")
    @JsonProperty(value="categories")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesforceSettings salesforceSettings = (SalesforceSettings)o;
        return Objects.equals((Object)this.channel, (Object)salesforceSettings.channel) && Objects.equals(this.language, salesforceSettings.language) && Objects.equals(this.categories, salesforceSettings.categories);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.channel, this.language, this.categories});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesforceSettings {\n");
        sb.append("    channel: ").append(this.toIndentedString((Object)this.channel)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ChannelEnumDeserializer.class)
    public static enum ChannelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        APP("App"),
        PKB("Pkb"),
        CSP("Csp"),
        PRM("Prm");

        private String value;

        private ChannelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ChannelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ChannelEnum value : ChannelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ChannelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ChannelEnumDeserializer
    extends StdDeserializer<ChannelEnum> {
        public ChannelEnumDeserializer() {
            super(ChannelEnumDeserializer.class);
        }

        public ChannelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ChannelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

