/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SendMessageBody;
import java.util.HashMap;
import java.util.Map;

public class PostChatsUserMessagesRequest {
    private String userId;
    private SendMessageBody body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PostChatsUserMessagesRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public SendMessageBody getBody() {
        return this.body;
    }

    public void setBody(SendMessageBody body) {
        this.body = body;
    }

    public PostChatsUserMessagesRequest withBody(SendMessageBody body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostChatsUserMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SendMessageBody> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostChatsUserMessagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostChatsUserMessagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/chats/users/{userId}/messages").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, SendMessageBody body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PostChatsUserMessagesRequest request = new PostChatsUserMessagesRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(SendMessageBody body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, SendMessageBody body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PostChatsUserMessagesRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostChatsUserMessagesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostChatsUserMessagesRequest.");
            }
            return this.request;
        }
    }
}

