/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FormsTrackTrigger;
import com.mypurecloud.sdk.v2.model.IdleEventTrigger;
import com.mypurecloud.sdk.v2.model.ScrollPercentageEventTrigger;
import com.mypurecloud.sdk.v2.model.SelectorEventTrigger;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Settings concerning journey events")
public class JourneyEventsSettings
implements Serializable {
    private Boolean enabled = null;
    private List<String> excludedQueryParameters = new ArrayList<String>();
    private Boolean shouldKeepUrlFragment = null;
    private List<String> searchQueryParameters = new ArrayList<String>();
    private PageviewConfigEnum pageviewConfig = null;
    private List<SelectorEventTrigger> clickEvents = new ArrayList<SelectorEventTrigger>();
    private List<FormsTrackTrigger> formsTrackEvents = new ArrayList<FormsTrackTrigger>();
    private List<IdleEventTrigger> idleEvents = new ArrayList<IdleEventTrigger>();
    private List<SelectorEventTrigger> inViewportEvents = new ArrayList<SelectorEventTrigger>();
    private List<ScrollPercentageEventTrigger> scrollDepthEvents = new ArrayList<ScrollPercentageEventTrigger>();

    public JourneyEventsSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not journey event collection is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public JourneyEventsSettings excludedQueryParameters(List<String> excludedQueryParameters) {
        this.excludedQueryParameters = excludedQueryParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="List of parameters to be excluded from the query string.")
    @JsonProperty(value="excludedQueryParameters")
    public List<String> getExcludedQueryParameters() {
        return this.excludedQueryParameters;
    }

    public void setExcludedQueryParameters(List<String> excludedQueryParameters) {
        this.excludedQueryParameters = excludedQueryParameters;
    }

    public JourneyEventsSettings shouldKeepUrlFragment(Boolean shouldKeepUrlFragment) {
        this.shouldKeepUrlFragment = shouldKeepUrlFragment;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not to keep the URL fragment.")
    @JsonProperty(value="shouldKeepUrlFragment")
    public Boolean getShouldKeepUrlFragment() {
        return this.shouldKeepUrlFragment;
    }

    public void setShouldKeepUrlFragment(Boolean shouldKeepUrlFragment) {
        this.shouldKeepUrlFragment = shouldKeepUrlFragment;
    }

    public JourneyEventsSettings searchQueryParameters(List<String> searchQueryParameters) {
        this.searchQueryParameters = searchQueryParameters;
        return this;
    }

    @ApiModelProperty(example="null", value="List of query parameters used for search (e.g. 'q').")
    @JsonProperty(value="searchQueryParameters")
    public List<String> getSearchQueryParameters() {
        return this.searchQueryParameters;
    }

    public void setSearchQueryParameters(List<String> searchQueryParameters) {
        this.searchQueryParameters = searchQueryParameters;
    }

    public JourneyEventsSettings pageviewConfig(PageviewConfigEnum pageviewConfig) {
        this.pageviewConfig = pageviewConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Controls how the pageview events are tracked.")
    @JsonProperty(value="pageviewConfig")
    public PageviewConfigEnum getPageviewConfig() {
        return this.pageviewConfig;
    }

    public void setPageviewConfig(PageviewConfigEnum pageviewConfig) {
        this.pageviewConfig = pageviewConfig;
    }

    public JourneyEventsSettings clickEvents(List<SelectorEventTrigger> clickEvents) {
        this.clickEvents = clickEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="Tracks when and where a visitor clicks on a webpage.")
    @JsonProperty(value="clickEvents")
    public List<SelectorEventTrigger> getClickEvents() {
        return this.clickEvents;
    }

    public void setClickEvents(List<SelectorEventTrigger> clickEvents) {
        this.clickEvents = clickEvents;
    }

    public JourneyEventsSettings formsTrackEvents(List<FormsTrackTrigger> formsTrackEvents) {
        this.formsTrackEvents = formsTrackEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="Controls how the form submitted and form abandoned events are tracked after a visitor interacts with a form element.")
    @JsonProperty(value="formsTrackEvents")
    public List<FormsTrackTrigger> getFormsTrackEvents() {
        return this.formsTrackEvents;
    }

    public void setFormsTrackEvents(List<FormsTrackTrigger> formsTrackEvents) {
        this.formsTrackEvents = formsTrackEvents;
    }

    public JourneyEventsSettings idleEvents(List<IdleEventTrigger> idleEvents) {
        this.idleEvents = idleEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="Tracks when and where a visitor becomes inactive on a webpage.")
    @JsonProperty(value="idleEvents")
    public List<IdleEventTrigger> getIdleEvents() {
        return this.idleEvents;
    }

    public void setIdleEvents(List<IdleEventTrigger> idleEvents) {
        this.idleEvents = idleEvents;
    }

    public JourneyEventsSettings inViewportEvents(List<SelectorEventTrigger> inViewportEvents) {
        this.inViewportEvents = inViewportEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="Tracks when elements become visible or hidden on screen.")
    @JsonProperty(value="inViewportEvents")
    public List<SelectorEventTrigger> getInViewportEvents() {
        return this.inViewportEvents;
    }

    public void setInViewportEvents(List<SelectorEventTrigger> inViewportEvents) {
        this.inViewportEvents = inViewportEvents;
    }

    public JourneyEventsSettings scrollDepthEvents(List<ScrollPercentageEventTrigger> scrollDepthEvents) {
        this.scrollDepthEvents = scrollDepthEvents;
        return this;
    }

    @ApiModelProperty(example="null", value="Tracks when a visitor scrolls to a specific percentage of a webpage.")
    @JsonProperty(value="scrollDepthEvents")
    public List<ScrollPercentageEventTrigger> getScrollDepthEvents() {
        return this.scrollDepthEvents;
    }

    public void setScrollDepthEvents(List<ScrollPercentageEventTrigger> scrollDepthEvents) {
        this.scrollDepthEvents = scrollDepthEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyEventsSettings journeyEventsSettings = (JourneyEventsSettings)o;
        return Objects.equals(this.enabled, journeyEventsSettings.enabled) && Objects.equals(this.excludedQueryParameters, journeyEventsSettings.excludedQueryParameters) && Objects.equals(this.shouldKeepUrlFragment, journeyEventsSettings.shouldKeepUrlFragment) && Objects.equals(this.searchQueryParameters, journeyEventsSettings.searchQueryParameters) && Objects.equals((Object)this.pageviewConfig, (Object)journeyEventsSettings.pageviewConfig) && Objects.equals(this.clickEvents, journeyEventsSettings.clickEvents) && Objects.equals(this.formsTrackEvents, journeyEventsSettings.formsTrackEvents) && Objects.equals(this.idleEvents, journeyEventsSettings.idleEvents) && Objects.equals(this.inViewportEvents, journeyEventsSettings.inViewportEvents) && Objects.equals(this.scrollDepthEvents, journeyEventsSettings.scrollDepthEvents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.excludedQueryParameters, this.shouldKeepUrlFragment, this.searchQueryParameters, this.pageviewConfig, this.clickEvents, this.formsTrackEvents, this.idleEvents, this.inViewportEvents, this.scrollDepthEvents});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyEventsSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    excludedQueryParameters: ").append(this.toIndentedString(this.excludedQueryParameters)).append("\n");
        sb.append("    shouldKeepUrlFragment: ").append(this.toIndentedString(this.shouldKeepUrlFragment)).append("\n");
        sb.append("    searchQueryParameters: ").append(this.toIndentedString(this.searchQueryParameters)).append("\n");
        sb.append("    pageviewConfig: ").append(this.toIndentedString((Object)this.pageviewConfig)).append("\n");
        sb.append("    clickEvents: ").append(this.toIndentedString(this.clickEvents)).append("\n");
        sb.append("    formsTrackEvents: ").append(this.toIndentedString(this.formsTrackEvents)).append("\n");
        sb.append("    idleEvents: ").append(this.toIndentedString(this.idleEvents)).append("\n");
        sb.append("    inViewportEvents: ").append(this.toIndentedString(this.inViewportEvents)).append("\n");
        sb.append("    scrollDepthEvents: ").append(this.toIndentedString(this.scrollDepthEvents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PageviewConfigEnumDeserializer.class)
    public static enum PageviewConfigEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTO("Auto"),
        ONCE("Once"),
        OFF("Off");

        private String value;

        private PageviewConfigEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PageviewConfigEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PageviewConfigEnum value : PageviewConfigEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PageviewConfigEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PageviewConfigEnumDeserializer
    extends StdDeserializer<PageviewConfigEnum> {
        public PageviewConfigEnumDeserializer() {
            super(PageviewConfigEnumDeserializer.class);
        }

        public PageviewConfigEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PageviewConfigEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

