/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.GrammarLanguage;
import java.util.HashMap;
import java.util.Map;

public class PostArchitectGrammarLanguagesRequest {
    private String grammarId;
    private GrammarLanguage body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGrammarId() {
        return this.grammarId;
    }

    public void setGrammarId(String grammarId) {
        this.grammarId = grammarId;
    }

    public PostArchitectGrammarLanguagesRequest withGrammarId(String grammarId) {
        this.setGrammarId(grammarId);
        return this;
    }

    public GrammarLanguage getBody() {
        return this.body;
    }

    public void setBody(GrammarLanguage body) {
        this.body = body;
    }

    public PostArchitectGrammarLanguagesRequest withBody(GrammarLanguage body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostArchitectGrammarLanguagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<GrammarLanguage> withHttpInfo() {
        if (this.grammarId == null) {
            throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PostArchitectGrammarLanguagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostArchitectGrammarLanguagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/architect/grammars/{grammarId}/languages").withPathParameter("grammarId", this.grammarId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String grammarId, GrammarLanguage body) {
        return new Builder().withRequiredParams(grammarId, body);
    }

    public static class Builder {
        private final PostArchitectGrammarLanguagesRequest request = new PostArchitectGrammarLanguagesRequest();

        private Builder() {
        }

        public Builder withGrammarId(String grammarId) {
            this.request.setGrammarId(grammarId);
            return this;
        }

        public Builder withBody(GrammarLanguage body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String grammarId, GrammarLanguage body) {
            this.request.setGrammarId(grammarId);
            this.request.setBody(body);
            return this;
        }

        public PostArchitectGrammarLanguagesRequest build() {
            if (this.request.grammarId == null) {
                throw new IllegalStateException("Missing the required parameter 'grammarId' when building request for PostArchitectGrammarLanguagesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostArchitectGrammarLanguagesRequest.");
            }
            return this.request;
        }
    }
}

