/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.OpenMessagingFromRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Open Channel-specific information that describes the message and the message channel/provider, with additional message information")
public class OpenInboundMessageMessagingChannel
implements Serializable {
    private OpenMessagingFromRecipient from = null;
    private Date time = null;
    private String messageId = null;
    private Object metadata = null;

    public OpenInboundMessageMessagingChannel from(OpenMessagingFromRecipient from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Information about the recipient the message is received from.")
    @JsonProperty(value="from")
    public OpenMessagingFromRecipient getFrom() {
        return this.from;
    }

    public void setFrom(OpenMessagingFromRecipient from) {
        this.from = from;
    }

    public OpenInboundMessageMessagingChannel time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public OpenInboundMessageMessagingChannel messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique provider ID of the message.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public OpenInboundMessageMessagingChannel metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional Custom Information about the channel.")
    @JsonProperty(value="metadata")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenInboundMessageMessagingChannel openInboundMessageMessagingChannel = (OpenInboundMessageMessagingChannel)o;
        return Objects.equals(this.from, openInboundMessageMessagingChannel.from) && Objects.equals(this.time, openInboundMessageMessagingChannel.time) && Objects.equals(this.messageId, openInboundMessageMessagingChannel.messageId) && Objects.equals(this.metadata, openInboundMessageMessagingChannel.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.time, this.messageId, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenInboundMessageMessagingChannel {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

