/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateEmailRequest
implements Serializable {
    private String queueId = null;
    private String flowId = null;
    private String provider = null;
    private List<String> skillIds = new ArrayList<String>();
    private String languageId = null;
    private Long priority = null;
    private Map<String, String> attributes = null;
    private String toAddress = null;
    private String toName = null;
    private String fromAddress = null;
    private String fromName = null;
    private String subject = null;
    private DirectionEnum direction = null;
    private String htmlBody = null;
    private String textBody = null;
    private String externalContactId = null;

    public CreateEmailRequest queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the queue to use for routing the email conversation. This field is mutually exclusive with flowId")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public CreateEmailRequest flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the flow to use for routing email conversation. This field is mutually exclusive with queueId")
    @JsonProperty(value="flowId")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public CreateEmailRequest provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the provider that is sourcing the emails. The Provider \"PureCloud Email\" is reserved for native emails.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public CreateEmailRequest skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of skill ID's to use for routing.")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public CreateEmailRequest languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the language to use for routing.")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public CreateEmailRequest priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority to assign to the conversation for routing.")
    @JsonProperty(value="priority")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public CreateEmailRequest attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of attributes to associate with the customer participant.")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public CreateEmailRequest toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address of the recipient of the email.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public CreateEmailRequest toName(String toName) {
        this.toName = toName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the recipient of the email.")
    @JsonProperty(value="toName")
    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    public CreateEmailRequest fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address of the sender of the email.")
    @JsonProperty(value="fromAddress")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public CreateEmailRequest fromName(String fromName) {
        this.fromName = fromName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the sender of the email.")
    @JsonProperty(value="fromName")
    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public CreateEmailRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject of the email")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public CreateEmailRequest direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify OUTBOUND to send an email on behalf of a queue, or INBOUND to create an external conversation. An external conversation is one where the provider is not PureCloud based.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public CreateEmailRequest htmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
        return this;
    }

    @ApiModelProperty(example="null", value="An HTML body content of the email.")
    @JsonProperty(value="htmlBody")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public CreateEmailRequest textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", value="A text body content of the email.")
    @JsonProperty(value="textBody")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public CreateEmailRequest externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The external contact with which the email should be associated. This field is only valid for OUTBOUND email.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateEmailRequest createEmailRequest = (CreateEmailRequest)o;
        return Objects.equals(this.queueId, createEmailRequest.queueId) && Objects.equals(this.flowId, createEmailRequest.flowId) && Objects.equals(this.provider, createEmailRequest.provider) && Objects.equals(this.skillIds, createEmailRequest.skillIds) && Objects.equals(this.languageId, createEmailRequest.languageId) && Objects.equals(this.priority, createEmailRequest.priority) && Objects.equals(this.attributes, createEmailRequest.attributes) && Objects.equals(this.toAddress, createEmailRequest.toAddress) && Objects.equals(this.toName, createEmailRequest.toName) && Objects.equals(this.fromAddress, createEmailRequest.fromAddress) && Objects.equals(this.fromName, createEmailRequest.fromName) && Objects.equals(this.subject, createEmailRequest.subject) && Objects.equals((Object)this.direction, (Object)createEmailRequest.direction) && Objects.equals(this.htmlBody, createEmailRequest.htmlBody) && Objects.equals(this.textBody, createEmailRequest.textBody) && Objects.equals(this.externalContactId, createEmailRequest.externalContactId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queueId, this.flowId, this.provider, this.skillIds, this.languageId, this.priority, this.attributes, this.toAddress, this.toName, this.fromAddress, this.fromName, this.subject, this.direction, this.htmlBody, this.textBody, this.externalContactId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateEmailRequest {\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    toName: ").append(this.toIndentedString(this.toName)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    fromName: ").append(this.toIndentedString(this.fromName)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    htmlBody: ").append(this.toIndentedString(this.htmlBody)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OUTBOUND("OUTBOUND"),
        INBOUND("INBOUND");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

