/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="User reaction to public message.")
public class ConversationContentReaction
implements Serializable {
    private ReactionTypeEnum reactionType = null;
    private Integer count = null;

    public ConversationContentReaction reactionType(ReactionTypeEnum reactionType) {
        this.reactionType = reactionType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of reaction.")
    @JsonProperty(value="reactionType")
    public ReactionTypeEnum getReactionType() {
        return this.reactionType;
    }

    public void setReactionType(ReactionTypeEnum reactionType) {
        this.reactionType = reactionType;
    }

    public ConversationContentReaction count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Number of users that reacted this way to the message.")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentReaction conversationContentReaction = (ConversationContentReaction)o;
        return Objects.equals((Object)this.reactionType, (Object)conversationContentReaction.reactionType) && Objects.equals(this.count, conversationContentReaction.count);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reactionType, this.count});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentReaction {\n");
        sb.append("    reactionType: ").append(this.toIndentedString((Object)this.reactionType)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ReactionTypeEnumDeserializer.class)
    public static enum ReactionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        LIKE("Like"),
        LOVE("Love"),
        WOW("Wow"),
        HAHA("Haha"),
        SAD("Sad"),
        ANGRY("Angry"),
        THANKFUL("Thankful"),
        PRIDE("Pride"),
        CARE("Care");

        private String value;

        private ReactionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReactionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReactionTypeEnum value : ReactionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReactionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ReactionTypeEnumDeserializer
    extends StdDeserializer<ReactionTypeEnum> {
        public ReactionTypeEnumDeserializer() {
            super(ReactionTypeEnumDeserializer.class);
        }

        public ReactionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReactionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

