/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Operand;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CategoryRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private InteractionTypeEnum interactionType = null;
    private Operand criteria = null;

    public CategoryRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the category")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CategoryRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the category")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CategoryRequest interactionType(InteractionTypeEnum interactionType) {
        this.interactionType = interactionType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of interaction the category will apply to")
    @JsonProperty(value="interactionType")
    public InteractionTypeEnum getInteractionType() {
        return this.interactionType;
    }

    public void setInteractionType(InteractionTypeEnum interactionType) {
        this.interactionType = interactionType;
    }

    public CategoryRequest criteria(Operand criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of conditions joined together by logical operation to provide more refined filtering of conversations")
    @JsonProperty(value="criteria")
    public Operand getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Operand criteria) {
        this.criteria = criteria;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryRequest categoryRequest = (CategoryRequest)o;
        return Objects.equals(this.name, categoryRequest.name) && Objects.equals(this.description, categoryRequest.description) && Objects.equals((Object)this.interactionType, (Object)categoryRequest.interactionType) && Objects.equals(this.criteria, categoryRequest.criteria);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.interactionType, this.criteria});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CategoryRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    interactionType: ").append(this.toIndentedString((Object)this.interactionType)).append("\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=InteractionTypeEnumDeserializer.class)
    public static enum InteractionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        DIGITAL("Digital"),
        ALL("All");

        private String value;

        private InteractionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InteractionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InteractionTypeEnum value : InteractionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InteractionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InteractionTypeEnumDeserializer
    extends StdDeserializer<InteractionTypeEnum> {
        public InteractionTypeEnumDeserializer() {
            super(InteractionTypeEnumDeserializer.class);
        }

        public InteractionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InteractionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

