/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserExternalIdentifier;
import java.util.HashMap;
import java.util.Map;

public class PostUserExternalidRequest {
    private String userId;
    private UserExternalIdentifier body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PostUserExternalidRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public UserExternalIdentifier getBody() {
        return this.body;
    }

    public void setBody(UserExternalIdentifier body) {
        this.body = body;
    }

    public PostUserExternalidRequest withBody(UserExternalIdentifier body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostUserExternalidRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserExternalIdentifier> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostUserExternalidRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostUserExternalidRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/users/{userId}/externalid").withPathParameter("userId", this.userId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, UserExternalIdentifier body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PostUserExternalidRequest request = new PostUserExternalidRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(UserExternalIdentifier body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, UserExternalIdentifier body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PostUserExternalidRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostUserExternalidRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostUserExternalidRequest.");
            }
            return this.request;
        }
    }
}

