/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneyViewVersionJobRequest {
    private String viewId;
    private String journeyVersionId;
    private String jobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public GetJourneyViewVersionJobRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getJourneyVersionId() {
        return this.journeyVersionId;
    }

    public void setJourneyVersionId(String journeyVersionId) {
        this.journeyVersionId = journeyVersionId;
    }

    public GetJourneyViewVersionJobRequest withJourneyVersionId(String journeyVersionId) {
        this.setJourneyVersionId(journeyVersionId);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public GetJourneyViewVersionJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneyViewVersionJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionJobRequest.");
        }
        if (this.journeyVersionId == null) {
            throw new IllegalStateException("Missing the required parameter 'journeyVersionId' when building request for GetJourneyViewVersionJobRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetJourneyViewVersionJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs/{jobId}").withPathParameter("viewId", this.viewId).withPathParameter("journeyVersionId", this.journeyVersionId).withPathParameter("jobId", this.jobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String journeyVersionId, String jobId) {
        return new Builder().withRequiredParams(viewId, journeyVersionId, jobId);
    }

    public static class Builder {
        private final GetJourneyViewVersionJobRequest request = new GetJourneyViewVersionJobRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withJourneyVersionId(String journeyVersionId) {
            this.request.setJourneyVersionId(journeyVersionId);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withRequiredParams(String viewId, String journeyVersionId, String jobId) {
            this.request.setViewId(viewId);
            this.request.setJourneyVersionId(journeyVersionId);
            this.request.setJobId(jobId);
            return this;
        }

        public GetJourneyViewVersionJobRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionJobRequest.");
            }
            if (this.request.journeyVersionId == null) {
                throw new IllegalStateException("Missing the required parameter 'journeyVersionId' when building request for GetJourneyViewVersionJobRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetJourneyViewVersionJobRequest.");
            }
            return this.request;
        }
    }
}

