/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.MetadataDocumentation;
import com.mypurecloud.sdk.v2.model.MetadataPresentation;
import com.mypurecloud.sdk.v2.model.MetadataResults;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Metadata for a CX infrastructure as code accelerator")
public class AcceleratorSpecification
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private OriginEnum origin = null;
    private TypeEnum type = null;
    private String classification = null;
    private List<String> tags = new ArrayList<String>();
    private List<String> permissions = new ArrayList<String>();
    private List<String> products = new ArrayList<String>();
    private List<MetadataDocumentation> documentation = new ArrayList<MetadataDocumentation>();
    private List<MetadataPresentation> presentation = new ArrayList<MetadataPresentation>();
    private MetadataResults results = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="name of this accelerator")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="a description of the general purpose of this accelerator")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="where the accelerator originated")
    @JsonProperty(value="origin")
    public OriginEnum getOrigin() {
        return this.origin;
    }

    @ApiModelProperty(example="null", value="type of the artifact")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="architectural classification into which the accelerator belongs")
    @JsonProperty(value="classification")
    public String getClassification() {
        return this.classification;
    }

    @ApiModelProperty(example="null", value="tags")
    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    @ApiModelProperty(example="null", value="Genesys Cloud permissions required to install the accelerator")
    @JsonProperty(value="permissions")
    public List<String> getPermissions() {
        return this.permissions;
    }

    @ApiModelProperty(example="null", value="Genesys Cloud products required to install the accelerator")
    @JsonProperty(value="products")
    public List<String> getProducts() {
        return this.products;
    }

    @ApiModelProperty(example="null", value="additional documentation about the artifact")
    @JsonProperty(value="documentation")
    public List<MetadataDocumentation> getDocumentation() {
        return this.documentation;
    }

    @ApiModelProperty(example="null", value="presentation of data fields to be gathered for the accelerator")
    @JsonProperty(value="presentation")
    public List<MetadataPresentation> getPresentation() {
        return this.presentation;
    }

    @ApiModelProperty(example="null", value="resources created or modified as a result of running the accelerator")
    @JsonProperty(value="results")
    public MetadataResults getResults() {
        return this.results;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceleratorSpecification acceleratorSpecification = (AcceleratorSpecification)o;
        return Objects.equals(this.id, acceleratorSpecification.id) && Objects.equals(this.name, acceleratorSpecification.name) && Objects.equals(this.description, acceleratorSpecification.description) && Objects.equals((Object)this.origin, (Object)acceleratorSpecification.origin) && Objects.equals((Object)this.type, (Object)acceleratorSpecification.type) && Objects.equals(this.classification, acceleratorSpecification.classification) && Objects.equals(this.tags, acceleratorSpecification.tags) && Objects.equals(this.permissions, acceleratorSpecification.permissions) && Objects.equals(this.products, acceleratorSpecification.products) && Objects.equals(this.documentation, acceleratorSpecification.documentation) && Objects.equals(this.presentation, acceleratorSpecification.presentation) && Objects.equals(this.results, acceleratorSpecification.results) && Objects.equals(this.selfUri, acceleratorSpecification.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.origin, this.type, this.classification, this.tags, this.permissions, this.products, this.documentation, this.presentation, this.results, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceleratorSpecification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString((Object)this.origin)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("    documentation: ").append(this.toIndentedString(this.documentation)).append("\n");
        sb.append("    presentation: ").append(this.toIndentedString(this.presentation)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OriginEnumDeserializer.class)
    public static enum OriginEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMMUNITY("Community"),
        PARTNER("Partner"),
        GENESYS("Genesys");

        private String value;

        private OriginEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginEnum value : OriginEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MODULE("Module"),
        ACCELERATOR("Accelerator"),
        BLUEPRINT("Blueprint");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OriginEnumDeserializer
    extends StdDeserializer<OriginEnum> {
        public OriginEnumDeserializer() {
            super(OriginEnumDeserializer.class);
        }

        public OriginEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

