/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents an individual result of an execution data lookup")
public class ExecutionDataEntity
implements Serializable {
    private String id = null;
    private String downloadUri = null;
    private Boolean failed = null;
    private String statusCode = null;

    public ExecutionDataEntity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the execution requested")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExecutionDataEntity downloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
        return this;
    }

    @ApiModelProperty(example="null", value="A downloadable link to the execution data file.")
    @JsonProperty(value="downloadUri")
    public String getDownloadUri() {
        return this.downloadUri;
    }

    public void setDownloadUri(String downloadUri) {
        this.downloadUri = downloadUri;
    }

    public ExecutionDataEntity failed(Boolean failed) {
        this.failed = failed;
        return this;
    }

    @ApiModelProperty(example="null", value="If the retrieval failed (not found, no permission, etc;), this will be set true.")
    @JsonProperty(value="failed")
    public Boolean getFailed() {
        return this.failed;
    }

    public void setFailed(Boolean failed) {
        this.failed = failed;
    }

    public ExecutionDataEntity statusCode(String statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @ApiModelProperty(example="null", value="This will contain the http status code for the failure")
    @JsonProperty(value="statusCode")
    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionDataEntity executionDataEntity = (ExecutionDataEntity)o;
        return Objects.equals(this.id, executionDataEntity.id) && Objects.equals(this.downloadUri, executionDataEntity.downloadUri) && Objects.equals(this.failed, executionDataEntity.failed) && Objects.equals(this.statusCode, executionDataEntity.statusCode);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.downloadUri, this.failed, this.statusCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecutionDataEntity {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    downloadUri: ").append(this.toIndentedString(this.downloadUri)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

