/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ChatReactionUpdate;
import java.util.HashMap;
import java.util.Map;

public class PutChatsMessageReactionsRequest {
    private String messageId;
    private ChatReactionUpdate body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public PutChatsMessageReactionsRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public ChatReactionUpdate getBody() {
        return this.body;
    }

    public void setBody(ChatReactionUpdate body) {
        this.body = body;
    }

    public PutChatsMessageReactionsRequest withBody(ChatReactionUpdate body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutChatsMessageReactionsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ChatReactionUpdate> withHttpInfo() {
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PutChatsMessageReactionsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutChatsMessageReactionsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/chats/messages/{messageId}/reactions").withPathParameter("messageId", this.messageId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String messageId, ChatReactionUpdate body) {
        return new Builder().withRequiredParams(messageId, body);
    }

    public static class Builder {
        private final PutChatsMessageReactionsRequest request = new PutChatsMessageReactionsRequest();

        private Builder() {
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withBody(ChatReactionUpdate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String messageId, ChatReactionUpdate body) {
            this.request.setMessageId(messageId);
            this.request.setBody(body);
            return this;
        }

        public PutChatsMessageReactionsRequest build() {
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PutChatsMessageReactionsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutChatsMessageReactionsRequest.");
            }
            return this.request;
        }
    }
}

