/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class RecordingEncryptionConfiguration
implements Serializable {
    private String id = null;
    private String url = null;
    private String apiId = null;
    private String apiKey = null;
    private KeyConfigurationTypeEnum keyConfigurationType = null;
    private ErrorBody lastError = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public RecordingEncryptionConfiguration url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="When keyConfigurationType is LocalKeyManager, this should be the url for decryption and must specify the path to where GenesysCloud can requests decryption. When keyConfigurationType is KmsSymmetric, this should be the arn to the key alias for the master key")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public RecordingEncryptionConfiguration apiId(String apiId) {
        this.apiId = apiId;
        return this;
    }

    @ApiModelProperty(example="null", value="The api id for Hawk Authentication. Null if keyConfigurationType is KmsSymmetric")
    @JsonProperty(value="apiId")
    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public RecordingEncryptionConfiguration apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(example="null", value="The api shared symmetric key used for hawk authentication. Null if keyConfigurationType is KmsSymmetric")
    @JsonProperty(value="apiKey")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public RecordingEncryptionConfiguration keyConfigurationType(KeyConfigurationTypeEnum keyConfigurationType) {
        this.keyConfigurationType = keyConfigurationType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type should be LocalKeyManager or KmsSymmetric when create or update Key configurations; 'Native' for disabling configuration.")
    @JsonProperty(value="keyConfigurationType")
    public KeyConfigurationTypeEnum getKeyConfigurationType() {
        return this.keyConfigurationType;
    }

    public void setKeyConfigurationType(KeyConfigurationTypeEnum keyConfigurationType) {
        this.keyConfigurationType = keyConfigurationType;
    }

    public RecordingEncryptionConfiguration lastError(ErrorBody lastError) {
        this.lastError = lastError;
        return this;
    }

    @ApiModelProperty(example="null", value="The error message related to the configuration")
    @JsonProperty(value="lastError")
    public ErrorBody getLastError() {
        return this.lastError;
    }

    public void setLastError(ErrorBody lastError) {
        this.lastError = lastError;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingEncryptionConfiguration recordingEncryptionConfiguration = (RecordingEncryptionConfiguration)o;
        return Objects.equals(this.id, recordingEncryptionConfiguration.id) && Objects.equals(this.url, recordingEncryptionConfiguration.url) && Objects.equals(this.apiId, recordingEncryptionConfiguration.apiId) && Objects.equals(this.apiKey, recordingEncryptionConfiguration.apiKey) && Objects.equals((Object)this.keyConfigurationType, (Object)recordingEncryptionConfiguration.keyConfigurationType) && Objects.equals(this.lastError, recordingEncryptionConfiguration.lastError) && Objects.equals(this.selfUri, recordingEncryptionConfiguration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.url, this.apiId, this.apiKey, this.keyConfigurationType, this.lastError, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingEncryptionConfiguration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    apiId: ").append(this.toIndentedString(this.apiId)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    keyConfigurationType: ").append(this.toIndentedString((Object)this.keyConfigurationType)).append("\n");
        sb.append("    lastError: ").append(this.toIndentedString(this.lastError)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=KeyConfigurationTypeEnumDeserializer.class)
    public static enum KeyConfigurationTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        KMSSYMMETRIC("KmsSymmetric"),
        LOCALKEYMANAGER("LocalKeyManager"),
        NATIVE("Native"),
        NONE("None");

        private String value;

        private KeyConfigurationTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KeyConfigurationTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KeyConfigurationTypeEnum value : KeyConfigurationTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KeyConfigurationTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class KeyConfigurationTypeEnumDeserializer
    extends StdDeserializer<KeyConfigurationTypeEnum> {
        public KeyConfigurationTypeEnumDeserializer() {
            super(KeyConfigurationTypeEnumDeserializer.class);
        }

        public KeyConfigurationTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KeyConfigurationTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

