/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ActivityPlanJobException;
import com.mypurecloud.sdk.v2.model.ActivityPlanReference;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ActivityPlanRunJobResponse
implements Serializable {
    private String id = null;
    private ActivityPlanReference activityPlan = null;
    private StatusEnum status = null;
    private List<ActivityPlanJobException> exceptions = new ArrayList<ActivityPlanJobException>();
    private ErrorBody error = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActivityPlanRunJobResponse activityPlan(ActivityPlanReference activityPlan) {
        this.activityPlan = activityPlan;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity plan associated with this job")
    @JsonProperty(value="activityPlan")
    public ActivityPlanReference getActivityPlan() {
        return this.activityPlan;
    }

    public void setActivityPlan(ActivityPlanReference activityPlan) {
        this.activityPlan = activityPlan;
    }

    public ActivityPlanRunJobResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ActivityPlanRunJobResponse exceptions(List<ActivityPlanJobException> exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of exceptions that occurred while running this activity plan job. These are exceptions that affect individual occurrences but didn't prevent the job from completing")
    @JsonProperty(value="exceptions")
    public List<ActivityPlanJobException> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ActivityPlanJobException> exceptions) {
        this.exceptions = exceptions;
    }

    public ActivityPlanRunJobResponse error(ErrorBody error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="Error details if status == 'Error'. These are errors that caused the job to fail to complete")
    @JsonProperty(value="error")
    public ErrorBody getError() {
        return this.error;
    }

    public void setError(ErrorBody error) {
        this.error = error;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityPlanRunJobResponse activityPlanRunJobResponse = (ActivityPlanRunJobResponse)o;
        return Objects.equals(this.id, activityPlanRunJobResponse.id) && Objects.equals(this.activityPlan, activityPlanRunJobResponse.activityPlan) && Objects.equals((Object)this.status, (Object)activityPlanRunJobResponse.status) && Objects.equals(this.exceptions, activityPlanRunJobResponse.exceptions) && Objects.equals(this.error, activityPlanRunJobResponse.error) && Objects.equals(this.selfUri, activityPlanRunJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.activityPlan, this.status, this.exceptions, this.error, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityPlanRunJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    activityPlan: ").append(this.toIndentedString(this.activityPlan)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    exceptions: ").append(this.toIndentedString(this.exceptions)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        ERROR("Error");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

