/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.FileWatcher;
import com.mypurecloud.sdk.v2.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class Configuration {
    private static ApiClient defaultApiClient = null;
    private static String configFilePath = null;
    private static Logger logger = null;
    private static FileWatcher configFileWatcher = null;
    private static FileWatcher.FileAdapter configListener = null;
    private static ApiClient.LoggingConfiguration loggingConfiguration;

    public static ApiClient getDefaultApiClient() {
        if (defaultApiClient == null) {
            defaultApiClient = new ApiClient();
        }
        return defaultApiClient;
    }

    public static void setDefaultApiClient(ApiClient apiClient) {
        defaultApiClient = apiClient;
        logger = defaultApiClient.getLogger();
        configFilePath = defaultApiClient.getConfigFilePath();
        loggingConfiguration = defaultApiClient.getLoggingConfiguration();
        Configuration configuration = new Configuration();
        configuration.applyConfigFromFile();
        configuration.configureAutoReload();
    }

    private boolean configureAutoReload() {
        boolean shouldSubscribeToFileWatcher;
        boolean shouldUnsubscribeFromFileWatcher = !defaultApiClient.getAutoReloadConfig() && configFileWatcher != null && configFileWatcher.getListeners().contains(configListener);
        boolean bl = shouldSubscribeToFileWatcher = defaultApiClient.getAutoReloadConfig() && (configFileWatcher == null || configFileWatcher.getListeners().size() == 0);
        if (shouldUnsubscribeFromFileWatcher) {
            return true;
        }
        if (shouldSubscribeToFileWatcher) {
            if (configFileWatcher == null) {
                this.initializeFileWatcher();
            } else {
                configFileWatcher.addListener(configListener);
            }
        }
        return false;
    }

    private String regexEscape(String str) {
        return str.replace("\\", "\\\\");
    }

    private void initializeFileWatcher() {
        File temp;
        File configFile = new File(configFilePath);
        File parentFolder = configFile.getParentFile();
        StringBuilder configFileName = new StringBuilder(Paths.get(configFilePath, new String[0]).getFileName().toString());
        while (parentFolder != null && !parentFolder.exists() && (temp = parentFolder.getParentFile()) != null) {
            parentFolder = temp;
            String[] splitPaths = this.regexEscape(configFile.getAbsolutePath()).split(this.regexEscape(parentFolder.getAbsolutePath()));
            configFileName = new StringBuilder(splitPaths[splitPaths.length - 1]);
        }
        if (parentFolder != null) {
            configListener = new FileWatcher.FileAdapter(){

                @Override
                public boolean onModified(FileWatcher.FileEvent event) {
                    Configuration.this.applyConfigFromFile();
                    return Configuration.this.configureAutoReload();
                }

                @Override
                public boolean onCreated(FileWatcher.FileEvent event) {
                    Configuration.this.applyConfigFromFile();
                    return Configuration.this.configureAutoReload();
                }
            };
            configFileWatcher = new FileWatcher(parentFolder, Paths.get(configFileName.toString(), new String[0])).addListener(configListener);
            configFileWatcher.watch();
        }
    }

    private void applyConfigFromFile() {
        String retryMax;
        String maxRetryTimeSec;
        String refreshTokenWaitTime;
        String refreshAccessToken;
        String liveReloadConfig;
        String host;
        String logResponseBody;
        String logRequestBody;
        String logFilePath;
        String logToConsole;
        String logFormat;
        ConfigurationParser parser = new ConfigurationParser(configFilePath);
        if (!parser.read()) {
            return;
        }
        String logLevel = parser.getString("logging", "log_level");
        if (logLevel != null && !logLevel.isEmpty()) {
            logger.setLevel(Logger.logLevelFromString(logLevel));
        }
        if ((logFormat = parser.getString("logging", "log_format")) != null && !logFormat.isEmpty()) {
            logger.setFormat(Logger.logFormatFromString(logFormat));
        }
        if ((logToConsole = parser.getString("logging", "log_to_console")) != null && !logToConsole.isEmpty()) {
            logger.setLogToConsole(parser.getBool("logging", "log_to_console"));
        }
        if ((logFilePath = parser.getString("logging", "log_file_path")) != null && !logFilePath.isEmpty()) {
            logger.setLogFilePath(logFilePath);
        }
        if ((logRequestBody = parser.getString("logging", "log_request_body")) != null && !logRequestBody.isEmpty()) {
            logger.setLogRequestBody(parser.getBool("logging", "log_request_body"));
        }
        if ((logResponseBody = parser.getString("logging", "log_response_body")) != null && !logResponseBody.isEmpty()) {
            logger.setLogResponseBody(parser.getBool("logging", "log_response_body"));
        }
        if ((host = parser.getString("general", "host")) != null && !host.isEmpty()) {
            defaultApiClient.setBasePath(host);
        }
        if ((liveReloadConfig = parser.getString("general", "live_reload_config")) != null && !liveReloadConfig.isEmpty()) {
            defaultApiClient.setAutoReloadConfig(parser.getBool("general", "live_reload_config"));
        }
        if ((refreshAccessToken = parser.getString("reauthentication", "refresh_access_token")) != null && !refreshAccessToken.isEmpty()) {
            defaultApiClient.setShouldRefreshAccessToken(parser.getBool("reauthentication", "refresh_access_token"));
        }
        if ((refreshTokenWaitTime = parser.getString("reauthentication", "refresh_token_wait_max")) != null && !refreshTokenWaitTime.isEmpty()) {
            defaultApiClient.setRefreshTokenWaitTime(parser.getInt("reauthentication", "refresh_token_wait_max"));
        }
        if ((maxRetryTimeSec = parser.getString("retry", "retry_wait_max")) != null && !maxRetryTimeSec.isEmpty()) {
            ApiClient.RetryConfiguration retryConfiguration = defaultApiClient.getRetryConfiguration();
            retryConfiguration.setMaxRetryTimeSec(parser.getInt("retry", "retry_wait_max"));
            defaultApiClient.setRetryConfiguration(retryConfiguration);
        }
        if ((retryMax = parser.getString("retry", "retry_max")) != null && !retryMax.isEmpty()) {
            ApiClient.RetryConfiguration retryConfiguration = defaultApiClient.getRetryConfiguration();
            retryConfiguration.setRetryMax(parser.getInt("retry", "retry_max"));
            defaultApiClient.setRetryConfiguration(retryConfiguration);
        }
    }

    private class ConfigurationParser {
        private String filePath;
        private FileFormat fileFormat;
        private Ini iniData;
        private Map<String, Object> jsonData;

        public ConfigurationParser(String filePath) {
            this.filePath = filePath;
            this.fileFormat = FileFormat.Invalid;
        }

        private boolean read() {
            boolean emptyData = true;
            try {
                byte[] data = Files.readAllBytes(Paths.get(this.filePath, new String[0]));
                String contents = new String(data).replaceAll("\\\\", "/");
                ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
                this.iniData = new Ini((InputStream)stream);
                this.fileFormat = FileFormat.INI;
                emptyData = this.iniData.isEmpty();
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (Exception e) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    File configFile = new File(this.filePath);
                    this.jsonData = (Map)objectMapper.readValue(configFile, Map.class);
                    this.fileFormat = FileFormat.JSON;
                    emptyData = this.jsonData == null || this.jsonData.isEmpty();
                }
                catch (Exception ex) {
                    return false;
                }
            }
            return !emptyData;
        }

        private String getString(String section, String key) {
            switch (this.fileFormat) {
                case INI: {
                    return this.getIniString(section, key);
                }
                case JSON: {
                    return this.getJsonString(section, key);
                }
            }
            return "";
        }

        private boolean getBool(String section, String key) {
            switch (this.fileFormat) {
                case INI: {
                    return this.getIniBool(section, key);
                }
                case JSON: {
                    return this.getJsonBool(section, key);
                }
            }
            return false;
        }

        private int getInt(String section, String key) {
            switch (this.fileFormat) {
                case INI: {
                    return this.getIniInt(section, key);
                }
                case JSON: {
                    return this.getJsonInt(section, key);
                }
            }
            return 0;
        }

        private String getJsonString(String section, String key) {
            try {
                Map sectionData = (Map)this.jsonData.get(section);
                return sectionData.get(key).toString().trim();
            }
            catch (Exception e) {
                return "";
            }
        }

        private boolean getJsonBool(String section, String key) {
            try {
                Map sectionData = (Map)this.jsonData.get(section);
                return Boolean.parseBoolean(sectionData.get(key).toString().trim());
            }
            catch (Exception e) {
                return false;
            }
        }

        private int getJsonInt(String section, String key) {
            try {
                Map sectionData = (Map)this.jsonData.get(section);
                return Integer.parseInt(sectionData.get(key).toString().trim());
            }
            catch (Exception e) {
                return -1;
            }
        }

        private String getIniString(String section, String key) {
            try {
                Profile.Section sectionData = (Profile.Section)this.iniData.get((Object)section);
                return ((String)sectionData.get((Object)key)).trim();
            }
            catch (Exception e) {
                return "";
            }
        }

        private boolean getIniBool(String section, String key) {
            try {
                Profile.Section sectionData = (Profile.Section)this.iniData.get((Object)section);
                return Boolean.parseBoolean(((String)sectionData.get((Object)key)).trim());
            }
            catch (Exception e) {
                return false;
            }
        }

        private int getIniInt(String section, String key) {
            try {
                Profile.Section sectionData = (Profile.Section)this.iniData.get((Object)section);
                return Integer.parseInt(((String)sectionData.get((Object)key)).trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    private static enum FileFormat {
        INI,
        Invalid,
        JSON;

    }
}

