/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.EmailMessage;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsEmailMessagesRequest {
    private String conversationId;
    private EmailMessage body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationsEmailMessagesRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public EmailMessage getBody() {
        return this.body;
    }

    public void setBody(EmailMessage body) {
        this.body = body;
    }

    public PostConversationsEmailMessagesRequest withBody(EmailMessage body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsEmailMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EmailMessage> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsEmailMessagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsEmailMessagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/emails/{conversationId}/messages").withPathParameter("conversationId", this.conversationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, EmailMessage body) {
        return new Builder().withRequiredParams(conversationId, body);
    }

    public static class Builder {
        private final PostConversationsEmailMessagesRequest request = new PostConversationsEmailMessagesRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withBody(EmailMessage body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, EmailMessage body) {
            this.request.setConversationId(conversationId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsEmailMessagesRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsEmailMessagesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsEmailMessagesRequest.");
            }
            return this.request;
        }
    }
}

