/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUsersDevelopmentActivityRequest {
    private String activityId;
    private String type;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public GetUsersDevelopmentActivityRequest withActivityId(String activityId) {
        this.setActivityId(activityId);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public GetUsersDevelopmentActivityRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersDevelopmentActivityRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.activityId == null) {
            throw new IllegalStateException("Missing the required parameter 'activityId' when building request for GetUsersDevelopmentActivityRequest.");
        }
        if (this.type == null) {
            throw new IllegalStateException("Missing the required parameter 'type' when building request for GetUsersDevelopmentActivityRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/development/activities/{activityId}").withPathParameter("activityId", this.activityId).withQueryParameters("type", "", this.type).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String activityId, String type) {
        return new Builder().withRequiredParams(activityId, type);
    }

    public static class Builder {
        private final GetUsersDevelopmentActivityRequest request = new GetUsersDevelopmentActivityRequest();

        private Builder() {
        }

        public Builder withActivityId(String activityId) {
            this.request.setActivityId(activityId);
            return this;
        }

        public Builder withType(String type) {
            this.request.setType(type);
            return this;
        }

        public Builder withType(typeValues type) {
            this.request.setType(type.toString());
            return this;
        }

        public Builder withRequiredParams(String activityId, String type) {
            this.request.setActivityId(activityId);
            this.request.setType(type);
            return this;
        }

        public GetUsersDevelopmentActivityRequest build() {
            if (this.request.activityId == null) {
                throw new IllegalStateException("Missing the required parameter 'activityId' when building request for GetUsersDevelopmentActivityRequest.");
            }
            if (this.request.type == null) {
                throw new IllegalStateException("Missing the required parameter 'type' when building request for GetUsersDevelopmentActivityRequest.");
            }
            return this.request;
        }
    }

    public static enum typeValues {
        INFORMATIONAL("Informational"),
        COACHING("Coaching"),
        ASSESSEDCONTENT("AssessedContent"),
        ASSESSMENT("Assessment"),
        EXTERNAL("External"),
        NATIVE("Native");

        private String value;

        private typeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static typeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (typeValues value : typeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return typeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

