/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.PostEventsConversationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostEventsUsersPresenceRequest;
import com.mypurecloud.sdk.v2.api.request.PostEventsUsersRoutingstatusRequest;
import com.mypurecloud.sdk.v2.model.BatchConversationEventRequest;
import com.mypurecloud.sdk.v2.model.BatchEventResponse;
import com.mypurecloud.sdk.v2.model.BatchUserPresenceEventRequest;
import com.mypurecloud.sdk.v2.model.BatchUserRoutingStatusEventRequest;
import java.io.IOException;

public class EventsApi {
    private final ApiClient pcapiClient;

    public EventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public BatchEventResponse postEventsConversations(BatchConversationEventRequest body) throws IOException, ApiException {
        return this.postEventsConversations(this.createPostEventsConversationsRequest(body));
    }

    public ApiResponse<BatchEventResponse> postEventsConversationsWithHttpInfo(BatchConversationEventRequest body) throws IOException {
        return this.postEventsConversations(this.createPostEventsConversationsRequest(body).withHttpInfo());
    }

    private PostEventsConversationsRequest createPostEventsConversationsRequest(BatchConversationEventRequest body) {
        return PostEventsConversationsRequest.builder().withBody(body).build();
    }

    public BatchEventResponse postEventsConversations(PostEventsConversationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BatchEventResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BatchEventResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BatchEventResponse> postEventsConversations(ApiRequest<BatchConversationEventRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BatchEventResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BatchEventResponse postEventsUsersPresence(BatchUserPresenceEventRequest body) throws IOException, ApiException {
        return this.postEventsUsersPresence(this.createPostEventsUsersPresenceRequest(body));
    }

    public ApiResponse<BatchEventResponse> postEventsUsersPresenceWithHttpInfo(BatchUserPresenceEventRequest body) throws IOException {
        return this.postEventsUsersPresence(this.createPostEventsUsersPresenceRequest(body).withHttpInfo());
    }

    private PostEventsUsersPresenceRequest createPostEventsUsersPresenceRequest(BatchUserPresenceEventRequest body) {
        return PostEventsUsersPresenceRequest.builder().withBody(body).build();
    }

    public BatchEventResponse postEventsUsersPresence(PostEventsUsersPresenceRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BatchEventResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BatchEventResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BatchEventResponse> postEventsUsersPresence(ApiRequest<BatchUserPresenceEventRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BatchEventResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BatchEventResponse postEventsUsersRoutingstatus(BatchUserRoutingStatusEventRequest body) throws IOException, ApiException {
        return this.postEventsUsersRoutingstatus(this.createPostEventsUsersRoutingstatusRequest(body));
    }

    public ApiResponse<BatchEventResponse> postEventsUsersRoutingstatusWithHttpInfo(BatchUserRoutingStatusEventRequest body) throws IOException {
        return this.postEventsUsersRoutingstatus(this.createPostEventsUsersRoutingstatusRequest(body).withHttpInfo());
    }

    private PostEventsUsersRoutingstatusRequest createPostEventsUsersRoutingstatusRequest(BatchUserRoutingStatusEventRequest body) {
        return PostEventsUsersRoutingstatusRequest.builder().withBody(body).build();
    }

    public BatchEventResponse postEventsUsersRoutingstatus(PostEventsUsersRoutingstatusRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BatchEventResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BatchEventResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BatchEventResponse> postEventsUsersRoutingstatus(ApiRequest<BatchUserRoutingStatusEventRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BatchEventResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

