/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FlowCharacteristics;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="This is a table of settings per a loglevel that define what will be logged in executionData when enabled (true)")
public class FlowLogLevel
implements Serializable {
    private LevelEnum level = null;
    private FlowCharacteristics characteristics = null;

    public FlowLogLevel level(LevelEnum level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(example="null", value="The logLevel for this characteristics set")
    @JsonProperty(value="level")
    public LevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    public FlowLogLevel characteristics(FlowCharacteristics characteristics) {
        this.characteristics = characteristics;
        return this;
    }

    @ApiModelProperty(example="null", value="Shows what characteristics are enabled for this log level")
    @JsonProperty(value="characteristics")
    public FlowCharacteristics getCharacteristics() {
        return this.characteristics;
    }

    public void setCharacteristics(FlowCharacteristics characteristics) {
        this.characteristics = characteristics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowLogLevel flowLogLevel = (FlowLogLevel)o;
        return Objects.equals((Object)this.level, (Object)flowLogLevel.level) && Objects.equals(this.characteristics, flowLogLevel.characteristics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.characteristics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowLogLevel {\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    characteristics: ").append(this.toIndentedString(this.characteristics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LevelEnumDeserializer.class)
    public static enum LevelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        DISABLED("Disabled"),
        BASE("Base"),
        NOTES("Notes"),
        VERBOSENOTES("VerboseNotes"),
        ALL("All");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LevelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LevelEnum value : LevelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LevelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LevelEnumDeserializer
    extends StdDeserializer<LevelEnum> {
        public LevelEnumDeserializer() {
            super(LevelEnumDeserializer.class);
        }

        public LevelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LevelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

