/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostKnowledgeKnowledgebaseLanguageTrainingsRequest {
    private String knowledgeBaseId;
    private String languageCode;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingsRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingsRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostKnowledgeKnowledgebaseLanguageTrainingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseLanguageTrainingsRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostKnowledgeKnowledgebaseLanguageTrainingsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/trainings").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("languageCode", this.languageCode).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String languageCode) {
        return new Builder().withRequiredParams(knowledgeBaseId, languageCode);
    }

    public static class Builder {
        private final PostKnowledgeKnowledgebaseLanguageTrainingsRequest request = new PostKnowledgeKnowledgebaseLanguageTrainingsRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withLanguageCode(languageCodeValues languageCode) {
            this.request.setLanguageCode(languageCode.toString());
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String languageCode) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public PostKnowledgeKnowledgebaseLanguageTrainingsRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PostKnowledgeKnowledgebaseLanguageTrainingsRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for PostKnowledgeKnowledgebaseLanguageTrainingsRequest.");
            }
            return this.request;
        }
    }

    public static enum languageCodeValues {
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        EN_CA("en-CA"),
        EN_HK("en-HK"),
        EN_IN("en-IN"),
        EN_IE("en-IE"),
        EN_NZ("en-NZ"),
        EN_PH("en-PH"),
        EN_SG("en-SG"),
        EN_ZA("en-ZA"),
        DE_DE("de-DE"),
        DE_AT("de-AT"),
        DE_CH("de-CH"),
        ES_AR("es-AR"),
        ES_CO("es-CO"),
        ES_MX("es-MX"),
        ES_US("es-US"),
        ES_ES("es-ES"),
        FR_FR("fr-FR"),
        FR_BE("fr-BE"),
        FR_CA("fr-CA"),
        FR_CH("fr-CH"),
        PT_BR("pt-BR"),
        PT_PT("pt-PT"),
        NL_NL("nl-NL"),
        NL_BE("nl-BE"),
        IT_IT("it-IT"),
        CA_ES("ca-ES"),
        TR_TR("tr-TR"),
        SV_SE("sv-SE"),
        FI_FI("fi-FI"),
        NB_NO("nb-NO"),
        DA_DK("da-DK"),
        JA_JP("ja-JP"),
        AR_AE("ar-AE"),
        ZH_CN("zh-CN"),
        ZH_TW("zh-TW"),
        ZH_HK("zh-HK"),
        KO_KR("ko-KR"),
        PL_PL("pl-PL");

        private String value;

        private languageCodeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static languageCodeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (languageCodeValues value : languageCodeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return languageCodeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

