/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class TransferToQueueRequest
implements Serializable {
    private TransferTypeEnum transferType = null;
    private String queueId = null;
    private String queueName = null;

    public TransferToQueueRequest transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of transfer to perform. Attended, where the initiating agent maintains ownership of the conversation until the intended recipient accepts the transfer, or Unattended, where the initiating agent immediately disconnects. Default is Unattended.")
    @JsonProperty(value="transferType")
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public TransferToQueueRequest queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the queue.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public TransferToQueueRequest queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the queue.")
    @JsonProperty(value="queueName")
    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferToQueueRequest transferToQueueRequest = (TransferToQueueRequest)o;
        return Objects.equals((Object)this.transferType, (Object)transferToQueueRequest.transferType) && Objects.equals(this.queueId, transferToQueueRequest.queueId) && Objects.equals(this.queueName, transferToQueueRequest.queueName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transferType, this.queueId, this.queueName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferToQueueRequest {\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    queueName: ").append(this.toIndentedString(this.queueName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TransferTypeEnumDeserializer.class)
    public static enum TransferTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTENDED("Attended"),
        UNATTENDED("Unattended");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TransferTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TransferTypeEnum value : TransferTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TransferTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TransferTypeEnumDeserializer
    extends StdDeserializer<TransferTypeEnum> {
        public TransferTypeEnumDeserializer() {
            super(TransferTypeEnumDeserializer.class);
        }

        public TransferTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TransferTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

