/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.KeyPerformanceIndicatorAssessment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BenefitAssessment
implements Serializable {
    private String id = null;
    private List<AddressableEntityRef> queues = new ArrayList<AddressableEntityRef>();
    private List<KeyPerformanceIndicatorAssessment> kpiAssessments = new ArrayList<KeyPerformanceIndicatorAssessment>();
    private StateEnum state = null;
    private String jobId = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The list of queues that are assessed for Predictive Routing benefit.")
    @JsonProperty(value="queues")
    public List<AddressableEntityRef> getQueues() {
        return this.queues;
    }

    @ApiModelProperty(example="null", value="A set of key performance indicators applied on the queue to determine suitability of Predictive Routing.")
    @JsonProperty(value="kpiAssessments")
    public List<KeyPerformanceIndicatorAssessment> getKpiAssessments() {
        return this.kpiAssessments;
    }

    @ApiModelProperty(example="null", value="State of the benefit assessment.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="The unique identifier of job that created this benefit assessment.")
    @JsonProperty(value="jobId")
    public String getJobId() {
        return this.jobId;
    }

    @ApiModelProperty(example="null", value="Creation Date of the benefit assessment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Modified Date of the benefit assessment. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BenefitAssessment benefitAssessment = (BenefitAssessment)o;
        return Objects.equals(this.id, benefitAssessment.id) && Objects.equals(this.queues, benefitAssessment.queues) && Objects.equals(this.kpiAssessments, benefitAssessment.kpiAssessments) && Objects.equals((Object)this.state, (Object)benefitAssessment.state) && Objects.equals(this.jobId, benefitAssessment.jobId) && Objects.equals(this.dateCreated, benefitAssessment.dateCreated) && Objects.equals(this.dateModified, benefitAssessment.dateModified) && Objects.equals(this.selfUri, benefitAssessment.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.queues, this.kpiAssessments, this.state, this.jobId, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BenefitAssessment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    kpiAssessments: ").append(this.toIndentedString(this.kpiAssessments)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        FINISHED("Finished"),
        FAILED("Failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

