/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ScheduleGenerationWarning
implements Serializable {
    private String userId = null;
    private Boolean userNotLicensed = null;
    private Boolean unableToMeetMaxDays = null;
    private List<UnableToScheduleRequiredDaysEnum> unableToScheduleRequiredDays = new ArrayList<UnableToScheduleRequiredDaysEnum>();
    private Boolean unableToMeetMinPaidForTheWeek = null;
    private Boolean unableToMeetMaxPaidForTheWeek = null;
    private List<NoNeedDaysEnum> noNeedDays = new ArrayList<NoNeedDaysEnum>();
    private Boolean shiftsTooCloseTogether = null;

    public ScheduleGenerationWarning userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the user in the warning")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ScheduleGenerationWarning userNotLicensed(Boolean userNotLicensed) {
        this.userNotLicensed = userNotLicensed;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the user does not have the appropriate license to be scheduled")
    @JsonProperty(value="userNotLicensed")
    public Boolean getUserNotLicensed() {
        return this.userNotLicensed;
    }

    public void setUserNotLicensed(Boolean userNotLicensed) {
        this.userNotLicensed = userNotLicensed;
    }

    public ScheduleGenerationWarning unableToMeetMaxDays(Boolean unableToMeetMaxDays) {
        this.unableToMeetMaxDays = unableToMeetMaxDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the number of scheduled days exceeded the maximum days to schedule defined in the agent work plan")
    @JsonProperty(value="unableToMeetMaxDays")
    public Boolean getUnableToMeetMaxDays() {
        return this.unableToMeetMaxDays;
    }

    public void setUnableToMeetMaxDays(Boolean unableToMeetMaxDays) {
        this.unableToMeetMaxDays = unableToMeetMaxDays;
    }

    public ScheduleGenerationWarning unableToScheduleRequiredDays(List<UnableToScheduleRequiredDaysEnum> unableToScheduleRequiredDays) {
        this.unableToScheduleRequiredDays = unableToScheduleRequiredDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Days indicated as required to work in agent work plan where no viable shift was found to schedule")
    @JsonProperty(value="unableToScheduleRequiredDays")
    public List<UnableToScheduleRequiredDaysEnum> getUnableToScheduleRequiredDays() {
        return this.unableToScheduleRequiredDays;
    }

    public void setUnableToScheduleRequiredDays(List<UnableToScheduleRequiredDaysEnum> unableToScheduleRequiredDays) {
        this.unableToScheduleRequiredDays = unableToScheduleRequiredDays;
    }

    public ScheduleGenerationWarning unableToMeetMinPaidForTheWeek(Boolean unableToMeetMinPaidForTheWeek) {
        this.unableToMeetMinPaidForTheWeek = unableToMeetMinPaidForTheWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the schedule did not meet the minimum paid time for the week defined in the agent work plan")
    @JsonProperty(value="unableToMeetMinPaidForTheWeek")
    public Boolean getUnableToMeetMinPaidForTheWeek() {
        return this.unableToMeetMinPaidForTheWeek;
    }

    public void setUnableToMeetMinPaidForTheWeek(Boolean unableToMeetMinPaidForTheWeek) {
        this.unableToMeetMinPaidForTheWeek = unableToMeetMinPaidForTheWeek;
    }

    public ScheduleGenerationWarning unableToMeetMaxPaidForTheWeek(Boolean unableToMeetMaxPaidForTheWeek) {
        this.unableToMeetMaxPaidForTheWeek = unableToMeetMaxPaidForTheWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the schedule exceeded the maximum paid time for the week defined in the agent work plan")
    @JsonProperty(value="unableToMeetMaxPaidForTheWeek")
    public Boolean getUnableToMeetMaxPaidForTheWeek() {
        return this.unableToMeetMaxPaidForTheWeek;
    }

    public void setUnableToMeetMaxPaidForTheWeek(Boolean unableToMeetMaxPaidForTheWeek) {
        this.unableToMeetMaxPaidForTheWeek = unableToMeetMaxPaidForTheWeek;
    }

    public ScheduleGenerationWarning noNeedDays(List<NoNeedDaysEnum> noNeedDays) {
        this.noNeedDays = noNeedDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Days agent was scheduled but there was no need to meet. The scheduled days have no effect on service levels")
    @JsonProperty(value="noNeedDays")
    public List<NoNeedDaysEnum> getNoNeedDays() {
        return this.noNeedDays;
    }

    public void setNoNeedDays(List<NoNeedDaysEnum> noNeedDays) {
        this.noNeedDays = noNeedDays;
    }

    public ScheduleGenerationWarning shiftsTooCloseTogether(Boolean shiftsTooCloseTogether) {
        this.shiftsTooCloseTogether = shiftsTooCloseTogether;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the schedule did not meet the minimum time between shifts defined in the agent work plan")
    @JsonProperty(value="shiftsTooCloseTogether")
    public Boolean getShiftsTooCloseTogether() {
        return this.shiftsTooCloseTogether;
    }

    public void setShiftsTooCloseTogether(Boolean shiftsTooCloseTogether) {
        this.shiftsTooCloseTogether = shiftsTooCloseTogether;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleGenerationWarning scheduleGenerationWarning = (ScheduleGenerationWarning)o;
        return Objects.equals(this.userId, scheduleGenerationWarning.userId) && Objects.equals(this.userNotLicensed, scheduleGenerationWarning.userNotLicensed) && Objects.equals(this.unableToMeetMaxDays, scheduleGenerationWarning.unableToMeetMaxDays) && Objects.equals(this.unableToScheduleRequiredDays, scheduleGenerationWarning.unableToScheduleRequiredDays) && Objects.equals(this.unableToMeetMinPaidForTheWeek, scheduleGenerationWarning.unableToMeetMinPaidForTheWeek) && Objects.equals(this.unableToMeetMaxPaidForTheWeek, scheduleGenerationWarning.unableToMeetMaxPaidForTheWeek) && Objects.equals(this.noNeedDays, scheduleGenerationWarning.noNeedDays) && Objects.equals(this.shiftsTooCloseTogether, scheduleGenerationWarning.shiftsTooCloseTogether);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.userNotLicensed, this.unableToMeetMaxDays, this.unableToScheduleRequiredDays, this.unableToMeetMinPaidForTheWeek, this.unableToMeetMaxPaidForTheWeek, this.noNeedDays, this.shiftsTooCloseTogether);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleGenerationWarning {\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    userNotLicensed: ").append(this.toIndentedString(this.userNotLicensed)).append("\n");
        sb.append("    unableToMeetMaxDays: ").append(this.toIndentedString(this.unableToMeetMaxDays)).append("\n");
        sb.append("    unableToScheduleRequiredDays: ").append(this.toIndentedString(this.unableToScheduleRequiredDays)).append("\n");
        sb.append("    unableToMeetMinPaidForTheWeek: ").append(this.toIndentedString(this.unableToMeetMinPaidForTheWeek)).append("\n");
        sb.append("    unableToMeetMaxPaidForTheWeek: ").append(this.toIndentedString(this.unableToMeetMaxPaidForTheWeek)).append("\n");
        sb.append("    noNeedDays: ").append(this.toIndentedString(this.noNeedDays)).append("\n");
        sb.append("    shiftsTooCloseTogether: ").append(this.toIndentedString(this.shiftsTooCloseTogether)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NoNeedDaysEnumDeserializer.class)
    public static enum NoNeedDaysEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private NoNeedDaysEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NoNeedDaysEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NoNeedDaysEnum value : NoNeedDaysEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NoNeedDaysEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NoNeedDaysEnumDeserializer
    extends StdDeserializer<NoNeedDaysEnum> {
        public NoNeedDaysEnumDeserializer() {
            super(NoNeedDaysEnumDeserializer.class);
        }

        public NoNeedDaysEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NoNeedDaysEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=UnableToScheduleRequiredDaysEnumDeserializer.class)
    public static enum UnableToScheduleRequiredDaysEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private UnableToScheduleRequiredDaysEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnableToScheduleRequiredDaysEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnableToScheduleRequiredDaysEnum value : UnableToScheduleRequiredDaysEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnableToScheduleRequiredDaysEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnableToScheduleRequiredDaysEnumDeserializer
    extends StdDeserializer<UnableToScheduleRequiredDaysEnum> {
        public UnableToScheduleRequiredDaysEnumDeserializer() {
            super(UnableToScheduleRequiredDaysEnumDeserializer.class);
        }

        public UnableToScheduleRequiredDaysEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnableToScheduleRequiredDaysEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

