/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.BaseMediaSettings;
import com.mypurecloud.sdk.v2.model.ServiceLevel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class CallbackMediaSettings
implements Serializable {
    private Boolean enableAutoAnswer = null;
    private Integer alertingTimeoutSeconds = null;
    private ServiceLevel serviceLevel = null;
    private Double autoAnswerAlertToneSeconds = null;
    private Double manualAnswerAlertToneSeconds = null;
    private Map<String, BaseMediaSettings> subTypeSettings = null;
    private Boolean enableAutoDialAndEnd = null;
    private Integer autoDialDelaySeconds = null;
    private Integer autoEndDelaySeconds = null;

    public CallbackMediaSettings enableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if auto-answer is enabled for the given media type or subtype (default is false).  Subtype settings take precedence over media type settings.")
    @JsonProperty(value="enableAutoAnswer")
    public Boolean getEnableAutoAnswer() {
        return this.enableAutoAnswer;
    }

    public void setEnableAutoAnswer(Boolean enableAutoAnswer) {
        this.enableAutoAnswer = enableAutoAnswer;
    }

    public CallbackMediaSettings alertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The alerting timeout for the media type, in seconds")
    @JsonProperty(value="alertingTimeoutSeconds")
    public Integer getAlertingTimeoutSeconds() {
        return this.alertingTimeoutSeconds;
    }

    public void setAlertingTimeoutSeconds(Integer alertingTimeoutSeconds) {
        this.alertingTimeoutSeconds = alertingTimeoutSeconds;
    }

    public CallbackMediaSettings serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(example="null", value="The targeted service level for the media type")
    @JsonProperty(value="serviceLevel")
    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public CallbackMediaSettings autoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for an auto-answer interaction")
    @JsonProperty(value="autoAnswerAlertToneSeconds")
    public Double getAutoAnswerAlertToneSeconds() {
        return this.autoAnswerAlertToneSeconds;
    }

    public void setAutoAnswerAlertToneSeconds(Double autoAnswerAlertToneSeconds) {
        this.autoAnswerAlertToneSeconds = autoAnswerAlertToneSeconds;
    }

    public CallbackMediaSettings manualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="How long to play the alerting tone for a manual-answer interaction")
    @JsonProperty(value="manualAnswerAlertToneSeconds")
    public Double getManualAnswerAlertToneSeconds() {
        return this.manualAnswerAlertToneSeconds;
    }

    public void setManualAnswerAlertToneSeconds(Double manualAnswerAlertToneSeconds) {
        this.manualAnswerAlertToneSeconds = manualAnswerAlertToneSeconds;
    }

    public CallbackMediaSettings subTypeSettings(Map<String, BaseMediaSettings> subTypeSettings) {
        this.subTypeSettings = subTypeSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of media subtype to media subtype specific settings.")
    @JsonProperty(value="subTypeSettings")
    public Map<String, BaseMediaSettings> getSubTypeSettings() {
        return this.subTypeSettings;
    }

    public void setSubTypeSettings(Map<String, BaseMediaSettings> subTypeSettings) {
        this.subTypeSettings = subTypeSettings;
    }

    public CallbackMediaSettings enableAutoDialAndEnd(Boolean enableAutoDialAndEnd) {
        this.enableAutoDialAndEnd = enableAutoDialAndEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to enable Auto-Dial and Auto-End automation for callbacks on this queue.")
    @JsonProperty(value="enableAutoDialAndEnd")
    public Boolean getEnableAutoDialAndEnd() {
        return this.enableAutoDialAndEnd;
    }

    public void setEnableAutoDialAndEnd(Boolean enableAutoDialAndEnd) {
        this.enableAutoDialAndEnd = enableAutoDialAndEnd;
    }

    public CallbackMediaSettings autoDialDelaySeconds(Integer autoDialDelaySeconds) {
        this.autoDialDelaySeconds = autoDialDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Time in seconds after agent connects to callback before outgoing call is auto-dialed. Allowable values in range 0 - 1200 seconds. Defaults to 300 seconds.")
    @JsonProperty(value="autoDialDelaySeconds")
    public Integer getAutoDialDelaySeconds() {
        return this.autoDialDelaySeconds;
    }

    public void setAutoDialDelaySeconds(Integer autoDialDelaySeconds) {
        this.autoDialDelaySeconds = autoDialDelaySeconds;
    }

    public CallbackMediaSettings autoEndDelaySeconds(Integer autoEndDelaySeconds) {
        this.autoEndDelaySeconds = autoEndDelaySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Time in seconds after agent disconnects from the outgoing call before the encasing callback is auto-ended. Allowable values in range 0 - 1200 seconds. Defaults to 300 seconds.")
    @JsonProperty(value="autoEndDelaySeconds")
    public Integer getAutoEndDelaySeconds() {
        return this.autoEndDelaySeconds;
    }

    public void setAutoEndDelaySeconds(Integer autoEndDelaySeconds) {
        this.autoEndDelaySeconds = autoEndDelaySeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallbackMediaSettings callbackMediaSettings = (CallbackMediaSettings)o;
        return Objects.equals(this.enableAutoAnswer, callbackMediaSettings.enableAutoAnswer) && Objects.equals(this.alertingTimeoutSeconds, callbackMediaSettings.alertingTimeoutSeconds) && Objects.equals(this.serviceLevel, callbackMediaSettings.serviceLevel) && Objects.equals(this.autoAnswerAlertToneSeconds, callbackMediaSettings.autoAnswerAlertToneSeconds) && Objects.equals(this.manualAnswerAlertToneSeconds, callbackMediaSettings.manualAnswerAlertToneSeconds) && Objects.equals(this.subTypeSettings, callbackMediaSettings.subTypeSettings) && Objects.equals(this.enableAutoDialAndEnd, callbackMediaSettings.enableAutoDialAndEnd) && Objects.equals(this.autoDialDelaySeconds, callbackMediaSettings.autoDialDelaySeconds) && Objects.equals(this.autoEndDelaySeconds, callbackMediaSettings.autoEndDelaySeconds);
    }

    public int hashCode() {
        return Objects.hash(this.enableAutoAnswer, this.alertingTimeoutSeconds, this.serviceLevel, this.autoAnswerAlertToneSeconds, this.manualAnswerAlertToneSeconds, this.subTypeSettings, this.enableAutoDialAndEnd, this.autoDialDelaySeconds, this.autoEndDelaySeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CallbackMediaSettings {\n");
        sb.append("    enableAutoAnswer: ").append(this.toIndentedString(this.enableAutoAnswer)).append("\n");
        sb.append("    alertingTimeoutSeconds: ").append(this.toIndentedString(this.alertingTimeoutSeconds)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString(this.serviceLevel)).append("\n");
        sb.append("    autoAnswerAlertToneSeconds: ").append(this.toIndentedString(this.autoAnswerAlertToneSeconds)).append("\n");
        sb.append("    manualAnswerAlertToneSeconds: ").append(this.toIndentedString(this.manualAnswerAlertToneSeconds)).append("\n");
        sb.append("    subTypeSettings: ").append(this.toIndentedString(this.subTypeSettings)).append("\n");
        sb.append("    enableAutoDialAndEnd: ").append(this.toIndentedString(this.enableAutoDialAndEnd)).append("\n");
        sb.append("    autoDialDelaySeconds: ").append(this.toIndentedString(this.autoDialDelaySeconds)).append("\n");
        sb.append("    autoEndDelaySeconds: ").append(this.toIndentedString(this.autoEndDelaySeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

