/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class TranscriptionSettings
implements Serializable {
    private TranscriptionEnum transcription = null;
    private Integer transcriptionConfidenceThreshold = null;
    private Boolean lowLatencyTranscriptionEnabled = null;
    private Boolean contentSearchEnabled = null;
    private Boolean pciDssRedactionEnabled = null;
    private Boolean piiRedactionEnabled = null;

    public TranscriptionSettings transcription(TranscriptionEnum transcription) {
        this.transcription = transcription;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Setting to enable/disable transcription capability")
    @JsonProperty(value="transcription")
    public TranscriptionEnum getTranscription() {
        return this.transcription;
    }

    public void setTranscription(TranscriptionEnum transcription) {
        this.transcription = transcription;
    }

    public TranscriptionSettings transcriptionConfidenceThreshold(Integer transcriptionConfidenceThreshold) {
        this.transcriptionConfidenceThreshold = transcriptionConfidenceThreshold;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Configure confidence threshold. The possible values are from 1 to 100.")
    @JsonProperty(value="transcriptionConfidenceThreshold")
    public Integer getTranscriptionConfidenceThreshold() {
        return this.transcriptionConfidenceThreshold;
    }

    public void setTranscriptionConfidenceThreshold(Integer transcriptionConfidenceThreshold) {
        this.transcriptionConfidenceThreshold = transcriptionConfidenceThreshold;
    }

    public TranscriptionSettings lowLatencyTranscriptionEnabled(Boolean lowLatencyTranscriptionEnabled) {
        this.lowLatencyTranscriptionEnabled = lowLatencyTranscriptionEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Boolean flag indicating whether low latency transcription via Notification API is enabled")
    @JsonProperty(value="lowLatencyTranscriptionEnabled")
    public Boolean getLowLatencyTranscriptionEnabled() {
        return this.lowLatencyTranscriptionEnabled;
    }

    public void setLowLatencyTranscriptionEnabled(Boolean lowLatencyTranscriptionEnabled) {
        this.lowLatencyTranscriptionEnabled = lowLatencyTranscriptionEnabled;
    }

    public TranscriptionSettings contentSearchEnabled(Boolean contentSearchEnabled) {
        this.contentSearchEnabled = contentSearchEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Setting to enable/disable content search")
    @JsonProperty(value="contentSearchEnabled")
    public Boolean getContentSearchEnabled() {
        return this.contentSearchEnabled;
    }

    public void setContentSearchEnabled(Boolean contentSearchEnabled) {
        this.contentSearchEnabled = contentSearchEnabled;
    }

    public TranscriptionSettings pciDssRedactionEnabled(Boolean pciDssRedactionEnabled) {
        this.pciDssRedactionEnabled = pciDssRedactionEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Setting to enable/disable PCI DSS Redaction")
    @JsonProperty(value="pciDssRedactionEnabled")
    public Boolean getPciDssRedactionEnabled() {
        return this.pciDssRedactionEnabled;
    }

    public void setPciDssRedactionEnabled(Boolean pciDssRedactionEnabled) {
        this.pciDssRedactionEnabled = pciDssRedactionEnabled;
    }

    public TranscriptionSettings piiRedactionEnabled(Boolean piiRedactionEnabled) {
        this.piiRedactionEnabled = piiRedactionEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Setting to enable/disable PII Redaction")
    @JsonProperty(value="piiRedactionEnabled")
    public Boolean getPiiRedactionEnabled() {
        return this.piiRedactionEnabled;
    }

    public void setPiiRedactionEnabled(Boolean piiRedactionEnabled) {
        this.piiRedactionEnabled = piiRedactionEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranscriptionSettings transcriptionSettings = (TranscriptionSettings)o;
        return Objects.equals((Object)this.transcription, (Object)transcriptionSettings.transcription) && Objects.equals(this.transcriptionConfidenceThreshold, transcriptionSettings.transcriptionConfidenceThreshold) && Objects.equals(this.lowLatencyTranscriptionEnabled, transcriptionSettings.lowLatencyTranscriptionEnabled) && Objects.equals(this.contentSearchEnabled, transcriptionSettings.contentSearchEnabled) && Objects.equals(this.pciDssRedactionEnabled, transcriptionSettings.pciDssRedactionEnabled) && Objects.equals(this.piiRedactionEnabled, transcriptionSettings.piiRedactionEnabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transcription, this.transcriptionConfidenceThreshold, this.lowLatencyTranscriptionEnabled, this.contentSearchEnabled, this.pciDssRedactionEnabled, this.piiRedactionEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TranscriptionSettings {\n");
        sb.append("    transcription: ").append(this.toIndentedString((Object)this.transcription)).append("\n");
        sb.append("    transcriptionConfidenceThreshold: ").append(this.toIndentedString(this.transcriptionConfidenceThreshold)).append("\n");
        sb.append("    lowLatencyTranscriptionEnabled: ").append(this.toIndentedString(this.lowLatencyTranscriptionEnabled)).append("\n");
        sb.append("    contentSearchEnabled: ").append(this.toIndentedString(this.contentSearchEnabled)).append("\n");
        sb.append("    pciDssRedactionEnabled: ").append(this.toIndentedString(this.pciDssRedactionEnabled)).append("\n");
        sb.append("    piiRedactionEnabled: ").append(this.toIndentedString(this.piiRedactionEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TranscriptionEnumDeserializer.class)
    public static enum TranscriptionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DISABLED("Disabled"),
        ENABLEDGLOBALLY("EnabledGlobally"),
        ENABLEDQUEUEFLOW("EnabledQueueFlow");

        private String value;

        private TranscriptionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TranscriptionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TranscriptionEnum value : TranscriptionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TranscriptionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TranscriptionEnumDeserializer
    extends StdDeserializer<TranscriptionEnum> {
        public TranscriptionEnumDeserializer() {
            super(TranscriptionEnumDeserializer.class);
        }

        public TranscriptionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TranscriptionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

