/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.EntityReference;
import com.mypurecloud.sdk.v2.model.KnowledgeConversationContextResponse;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentVersionReference;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeDocumentFeedbackResponse
implements Serializable {
    private String id = null;
    private EntityReference documentVariation = null;
    private RatingEnum rating = null;
    private ReasonEnum reason = null;
    private String comment = null;
    private EntityReference search = null;
    private String sessionId = null;
    private Date dateCreated = null;
    private QueryTypeEnum queryType = null;
    private StateEnum state = null;
    private KnowledgeDocumentVersionReference document = null;
    private KnowledgeSearchClientApplication application = null;
    private KnowledgeConversationContextResponse conversationContext = null;
    private AddressableEntityRef user = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeDocumentFeedbackResponse documentVariation(EntityReference documentVariation) {
        this.documentVariation = documentVariation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The variation of the document on which feedback was given.")
    @JsonProperty(value="documentVariation")
    public EntityReference getDocumentVariation() {
        return this.documentVariation;
    }

    public void setDocumentVariation(EntityReference documentVariation) {
        this.documentVariation = documentVariation;
    }

    public KnowledgeDocumentFeedbackResponse rating(RatingEnum rating) {
        this.rating = rating;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Feedback rating.")
    @JsonProperty(value="rating")
    public RatingEnum getRating() {
        return this.rating;
    }

    public void setRating(RatingEnum rating) {
        this.rating = rating;
    }

    public KnowledgeDocumentFeedbackResponse reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="null", value="Feedback reason.")
    @JsonProperty(value="reason")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public KnowledgeDocumentFeedbackResponse comment(String comment) {
        this.comment = comment;
        return this;
    }

    @ApiModelProperty(example="null", value="Free-text comment of the feedback. Maximum length: 2000 characters.")
    @JsonProperty(value="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public KnowledgeDocumentFeedbackResponse search(EntityReference search) {
        this.search = search;
        return this;
    }

    @ApiModelProperty(example="null", value="The search that surfaced the document on which feedback was given.")
    @JsonProperty(value="search")
    public EntityReference getSearch() {
        return this.search;
    }

    public void setSearch(EntityReference search) {
        this.search = search;
    }

    @ApiModelProperty(example="null", value="Knowledge guest session ID.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    @ApiModelProperty(example="null", value="The date and time of the feedback. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public KnowledgeDocumentFeedbackResponse queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that surfaced the document on which the feedback was given.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeDocumentFeedbackResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the feedback.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public KnowledgeDocumentFeedbackResponse document(KnowledgeDocumentVersionReference document) {
        this.document = document;
        return this;
    }

    @ApiModelProperty(example="null", value="The document on which feedback was given.")
    @JsonProperty(value="document")
    public KnowledgeDocumentVersionReference getDocument() {
        return this.document;
    }

    public void setDocument(KnowledgeDocumentVersionReference document) {
        this.document = document;
    }

    public KnowledgeDocumentFeedbackResponse application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="The client application from which feedback was given.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public KnowledgeDocumentFeedbackResponse conversationContext(KnowledgeConversationContextResponse conversationContext) {
        this.conversationContext = conversationContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation context information if the feedback is given in the context of a conversation.")
    @JsonProperty(value="conversationContext")
    public KnowledgeConversationContextResponse getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(KnowledgeConversationContextResponse conversationContext) {
        this.conversationContext = conversationContext;
    }

    @ApiModelProperty(example="null", value="The user who created the feedback.")
    @JsonProperty(value="user")
    public AddressableEntityRef getUser() {
        return this.user;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentFeedbackResponse knowledgeDocumentFeedbackResponse = (KnowledgeDocumentFeedbackResponse)o;
        return Objects.equals(this.id, knowledgeDocumentFeedbackResponse.id) && Objects.equals(this.documentVariation, knowledgeDocumentFeedbackResponse.documentVariation) && Objects.equals((Object)this.rating, (Object)knowledgeDocumentFeedbackResponse.rating) && Objects.equals((Object)this.reason, (Object)knowledgeDocumentFeedbackResponse.reason) && Objects.equals(this.comment, knowledgeDocumentFeedbackResponse.comment) && Objects.equals(this.search, knowledgeDocumentFeedbackResponse.search) && Objects.equals(this.sessionId, knowledgeDocumentFeedbackResponse.sessionId) && Objects.equals(this.dateCreated, knowledgeDocumentFeedbackResponse.dateCreated) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentFeedbackResponse.queryType) && Objects.equals((Object)this.state, (Object)knowledgeDocumentFeedbackResponse.state) && Objects.equals(this.document, knowledgeDocumentFeedbackResponse.document) && Objects.equals(this.application, knowledgeDocumentFeedbackResponse.application) && Objects.equals(this.conversationContext, knowledgeDocumentFeedbackResponse.conversationContext) && Objects.equals(this.user, knowledgeDocumentFeedbackResponse.user) && Objects.equals(this.selfUri, knowledgeDocumentFeedbackResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.documentVariation, this.rating, this.reason, this.comment, this.search, this.sessionId, this.dateCreated, this.queryType, this.state, this.document, this.application, this.conversationContext, this.user, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentFeedbackResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    documentVariation: ").append(this.toIndentedString(this.documentVariation)).append("\n");
        sb.append("    rating: ").append(this.toIndentedString((Object)this.rating)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    search: ").append(this.toIndentedString(this.search)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    conversationContext: ").append(this.toIndentedString(this.conversationContext)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RatingEnumDeserializer.class)
    public static enum RatingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NEGATIVE("Negative"),
        POSITIVE("Positive");

        private String value;

        private RatingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RatingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RatingEnum value : RatingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RatingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ReasonEnumDeserializer.class)
    public static enum ReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DOCUMENTCONTENT("DocumentContent"),
        SEARCHRESULTS("SearchResults");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ReasonEnum value : ReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ARTICLE("Article"),
        AUTOSEARCH("AutoSearch"),
        CATEGORY("Category"),
        MANUALSEARCH("ManualSearch"),
        RECOMMENDATION("Recommendation"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        FINAL("Final");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ReasonEnumDeserializer
    extends StdDeserializer<ReasonEnum> {
        public ReasonEnumDeserializer() {
            super(ReasonEnumDeserializer.class);
        }

        public ReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RatingEnumDeserializer
    extends StdDeserializer<RatingEnum> {
        public RatingEnumDeserializer() {
            super(RatingEnumDeserializer.class);
        }

        public RatingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RatingEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

