/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Annotation;
import com.mypurecloud.sdk.v2.model.ChatMessage;
import com.mypurecloud.sdk.v2.model.MediaResult;
import com.mypurecloud.sdk.v2.model.RecordingEmailMessage;
import com.mypurecloud.sdk.v2.model.RecordingMessagingMessage;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Recording
implements Serializable {
    private String id = null;
    private String name = null;
    private String conversationId = null;
    private String path = null;
    private String startTime = null;
    private String endTime = null;
    private String media = null;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private List<ChatMessage> transcript = new ArrayList<ChatMessage>();
    private List<RecordingEmailMessage> emailTranscript = new ArrayList<RecordingEmailMessage>();
    private List<RecordingMessagingMessage> messagingTranscript = new ArrayList<RecordingMessagingMessage>();
    private FileStateEnum fileState = null;
    private Date restoreExpirationTime = null;
    private Map<String, MediaResult> mediaUris = null;
    private Long estimatedTranscodeTimeMs = null;
    private Long actualTranscodeTimeMs = null;
    private Date archiveDate = null;
    private ArchiveMediumEnum archiveMedium = null;
    private Date deleteDate = null;
    private Date exportDate = null;
    private Date exportedDate = null;
    private Integer outputDurationMs = null;
    private Integer outputSizeInBytes = null;
    private Integer maxAllowedRestorationsForOrg = null;
    private Integer remainingRestorationsAllowedForOrg = null;
    private String sessionId = null;
    private List<User> users = new ArrayList<User>();
    private RecordingFileRoleEnum recordingFileRole = null;
    private RecordingErrorStatusEnum recordingErrorStatus = null;
    private Date originalRecordingStartTime = null;
    private Date creationTime = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Recording name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Recording conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Recording path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Recording startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of the recording. Null when there is no playable media.")
    @JsonProperty(value="startTime")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public Recording endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The end time of the recording. Null when there is no playable media.")
    @JsonProperty(value="endTime")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Recording media(String media) {
        this.media = media;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the recording. This could be audio, chat, messaging, email, or screen.")
    @JsonProperty(value="media")
    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public Recording annotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    @ApiModelProperty(example="null", value="Annotations that belong to the recording.")
    @JsonProperty(value="annotations")
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public Recording transcript(List<ChatMessage> transcript) {
        this.transcript = transcript;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents a chat transcript")
    @JsonProperty(value="transcript")
    public List<ChatMessage> getTranscript() {
        return this.transcript;
    }

    public void setTranscript(List<ChatMessage> transcript) {
        this.transcript = transcript;
    }

    public Recording emailTranscript(List<RecordingEmailMessage> emailTranscript) {
        this.emailTranscript = emailTranscript;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents an email transcript")
    @JsonProperty(value="emailTranscript")
    public List<RecordingEmailMessage> getEmailTranscript() {
        return this.emailTranscript;
    }

    public void setEmailTranscript(List<RecordingEmailMessage> emailTranscript) {
        this.emailTranscript = emailTranscript;
    }

    public Recording messagingTranscript(List<RecordingMessagingMessage> messagingTranscript) {
        this.messagingTranscript = messagingTranscript;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents a messaging transcript")
    @JsonProperty(value="messagingTranscript")
    public List<RecordingMessagingMessage> getMessagingTranscript() {
        return this.messagingTranscript;
    }

    public void setMessagingTranscript(List<RecordingMessagingMessage> messagingTranscript) {
        this.messagingTranscript = messagingTranscript;
    }

    public Recording fileState(FileStateEnum fileState) {
        this.fileState = fileState;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the current file state for a recording. Examples: Uploading, Archived, etc")
    @JsonProperty(value="fileState")
    public FileStateEnum getFileState() {
        return this.fileState;
    }

    public void setFileState(FileStateEnum fileState) {
        this.fileState = fileState;
    }

    public Recording restoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time a restored recording will remain restored before being archived again. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="restoreExpirationTime")
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    public Recording mediaUris(Map<String, MediaResult> mediaUris) {
        this.mediaUris = mediaUris;
        return this;
    }

    @ApiModelProperty(example="null", value="The different mediaUris for the recording. Null when there is no playable media.")
    @JsonProperty(value="mediaUris")
    public Map<String, MediaResult> getMediaUris() {
        return this.mediaUris;
    }

    public void setMediaUris(Map<String, MediaResult> mediaUris) {
        this.mediaUris = mediaUris;
    }

    public Recording estimatedTranscodeTimeMs(Long estimatedTranscodeTimeMs) {
        this.estimatedTranscodeTimeMs = estimatedTranscodeTimeMs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="estimatedTranscodeTimeMs")
    public Long getEstimatedTranscodeTimeMs() {
        return this.estimatedTranscodeTimeMs;
    }

    public void setEstimatedTranscodeTimeMs(Long estimatedTranscodeTimeMs) {
        this.estimatedTranscodeTimeMs = estimatedTranscodeTimeMs;
    }

    public Recording actualTranscodeTimeMs(Long actualTranscodeTimeMs) {
        this.actualTranscodeTimeMs = actualTranscodeTimeMs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="actualTranscodeTimeMs")
    public Long getActualTranscodeTimeMs() {
        return this.actualTranscodeTimeMs;
    }

    public void setActualTranscodeTimeMs(Long actualTranscodeTimeMs) {
        this.actualTranscodeTimeMs = actualTranscodeTimeMs;
    }

    public Recording archiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="archiveDate")
    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public Recording archiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of archive medium used. Example: CloudArchive")
    @JsonProperty(value="archiveMedium")
    public ArchiveMediumEnum getArchiveMedium() {
        return this.archiveMedium;
    }

    public void setArchiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
    }

    public Recording deleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="deleteDate")
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public Recording exportDate(Date exportDate) {
        this.exportDate = exportDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportDate")
    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(Date exportDate) {
        this.exportDate = exportDate;
    }

    public Recording exportedDate(Date exportedDate) {
        this.exportedDate = exportedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording was exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportedDate")
    public Date getExportedDate() {
        return this.exportedDate;
    }

    public void setExportedDate(Date exportedDate) {
        this.exportedDate = exportedDate;
    }

    public Recording outputDurationMs(Integer outputDurationMs) {
        this.outputDurationMs = outputDurationMs;
        return this;
    }

    @ApiModelProperty(example="null", value="Duration of transcoded media in milliseconds")
    @JsonProperty(value="outputDurationMs")
    public Integer getOutputDurationMs() {
        return this.outputDurationMs;
    }

    public void setOutputDurationMs(Integer outputDurationMs) {
        this.outputDurationMs = outputDurationMs;
    }

    public Recording outputSizeInBytes(Integer outputSizeInBytes) {
        this.outputSizeInBytes = outputSizeInBytes;
        return this;
    }

    @ApiModelProperty(example="null", value="Size of transcoded media in bytes. 0 if there is no transcoded media.")
    @JsonProperty(value="outputSizeInBytes")
    public Integer getOutputSizeInBytes() {
        return this.outputSizeInBytes;
    }

    public void setOutputSizeInBytes(Integer outputSizeInBytes) {
        this.outputSizeInBytes = outputSizeInBytes;
    }

    public Recording maxAllowedRestorationsForOrg(Integer maxAllowedRestorationsForOrg) {
        this.maxAllowedRestorationsForOrg = maxAllowedRestorationsForOrg;
        return this;
    }

    @ApiModelProperty(example="null", value="How many archive restorations the organization is allowed to have.")
    @JsonProperty(value="maxAllowedRestorationsForOrg")
    public Integer getMaxAllowedRestorationsForOrg() {
        return this.maxAllowedRestorationsForOrg;
    }

    public void setMaxAllowedRestorationsForOrg(Integer maxAllowedRestorationsForOrg) {
        this.maxAllowedRestorationsForOrg = maxAllowedRestorationsForOrg;
    }

    public Recording remainingRestorationsAllowedForOrg(Integer remainingRestorationsAllowedForOrg) {
        this.remainingRestorationsAllowedForOrg = remainingRestorationsAllowedForOrg;
        return this;
    }

    @ApiModelProperty(example="null", value="The remaining archive restorations the organization has.")
    @JsonProperty(value="remainingRestorationsAllowedForOrg")
    public Integer getRemainingRestorationsAllowedForOrg() {
        return this.remainingRestorationsAllowedForOrg;
    }

    public void setRemainingRestorationsAllowedForOrg(Integer remainingRestorationsAllowedForOrg) {
        this.remainingRestorationsAllowedForOrg = remainingRestorationsAllowedForOrg;
    }

    public Recording sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The session id represents an external resource id, such as email, call, chat, etc")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Recording users(List<User> users) {
        this.users = users;
        return this;
    }

    @ApiModelProperty(example="null", value="The users participating in the conversation")
    @JsonProperty(value="users")
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public Recording recordingFileRole(RecordingFileRoleEnum recordingFileRole) {
        this.recordingFileRole = recordingFileRole;
        return this;
    }

    @ApiModelProperty(example="null", value="Role of the file recording. It can be either customer_experience or adhoc.")
    @JsonProperty(value="recordingFileRole")
    public RecordingFileRoleEnum getRecordingFileRole() {
        return this.recordingFileRole;
    }

    public void setRecordingFileRole(RecordingFileRoleEnum recordingFileRole) {
        this.recordingFileRole = recordingFileRole;
    }

    public Recording recordingErrorStatus(RecordingErrorStatusEnum recordingErrorStatus) {
        this.recordingErrorStatus = recordingErrorStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of a recording that cannot be returned because of an error")
    @JsonProperty(value="recordingErrorStatus")
    public RecordingErrorStatusEnum getRecordingErrorStatus() {
        return this.recordingErrorStatus;
    }

    public void setRecordingErrorStatus(RecordingErrorStatusEnum recordingErrorStatus) {
        this.recordingErrorStatus = recordingErrorStatus;
    }

    public Recording originalRecordingStartTime(Date originalRecordingStartTime) {
        this.originalRecordingStartTime = originalRecordingStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of the full recording, before any segment access restrictions are applied. Null when there is no playable media. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="originalRecordingStartTime")
    public Date getOriginalRecordingStartTime() {
        return this.originalRecordingStartTime;
    }

    public void setOriginalRecordingStartTime(Date originalRecordingStartTime) {
        this.originalRecordingStartTime = originalRecordingStartTime;
    }

    public Recording creationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The creation time of the recording. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="creationTime")
    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording recording = (Recording)o;
        return Objects.equals(this.id, recording.id) && Objects.equals(this.name, recording.name) && Objects.equals(this.conversationId, recording.conversationId) && Objects.equals(this.path, recording.path) && Objects.equals(this.startTime, recording.startTime) && Objects.equals(this.endTime, recording.endTime) && Objects.equals(this.media, recording.media) && Objects.equals(this.annotations, recording.annotations) && Objects.equals(this.transcript, recording.transcript) && Objects.equals(this.emailTranscript, recording.emailTranscript) && Objects.equals(this.messagingTranscript, recording.messagingTranscript) && Objects.equals((Object)this.fileState, (Object)recording.fileState) && Objects.equals(this.restoreExpirationTime, recording.restoreExpirationTime) && Objects.equals(this.mediaUris, recording.mediaUris) && Objects.equals(this.estimatedTranscodeTimeMs, recording.estimatedTranscodeTimeMs) && Objects.equals(this.actualTranscodeTimeMs, recording.actualTranscodeTimeMs) && Objects.equals(this.archiveDate, recording.archiveDate) && Objects.equals((Object)this.archiveMedium, (Object)recording.archiveMedium) && Objects.equals(this.deleteDate, recording.deleteDate) && Objects.equals(this.exportDate, recording.exportDate) && Objects.equals(this.exportedDate, recording.exportedDate) && Objects.equals(this.outputDurationMs, recording.outputDurationMs) && Objects.equals(this.outputSizeInBytes, recording.outputSizeInBytes) && Objects.equals(this.maxAllowedRestorationsForOrg, recording.maxAllowedRestorationsForOrg) && Objects.equals(this.remainingRestorationsAllowedForOrg, recording.remainingRestorationsAllowedForOrg) && Objects.equals(this.sessionId, recording.sessionId) && Objects.equals(this.users, recording.users) && Objects.equals((Object)this.recordingFileRole, (Object)recording.recordingFileRole) && Objects.equals((Object)this.recordingErrorStatus, (Object)recording.recordingErrorStatus) && Objects.equals(this.originalRecordingStartTime, recording.originalRecordingStartTime) && Objects.equals(this.creationTime, recording.creationTime) && Objects.equals(this.selfUri, recording.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.conversationId, this.path, this.startTime, this.endTime, this.media, this.annotations, this.transcript, this.emailTranscript, this.messagingTranscript, this.fileState, this.restoreExpirationTime, this.mediaUris, this.estimatedTranscodeTimeMs, this.actualTranscodeTimeMs, this.archiveDate, this.archiveMedium, this.deleteDate, this.exportDate, this.exportedDate, this.outputDurationMs, this.outputSizeInBytes, this.maxAllowedRestorationsForOrg, this.remainingRestorationsAllowedForOrg, this.sessionId, this.users, this.recordingFileRole, this.recordingErrorStatus, this.originalRecordingStartTime, this.creationTime, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recording {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    transcript: ").append(this.toIndentedString(this.transcript)).append("\n");
        sb.append("    emailTranscript: ").append(this.toIndentedString(this.emailTranscript)).append("\n");
        sb.append("    messagingTranscript: ").append(this.toIndentedString(this.messagingTranscript)).append("\n");
        sb.append("    fileState: ").append(this.toIndentedString((Object)this.fileState)).append("\n");
        sb.append("    restoreExpirationTime: ").append(this.toIndentedString(this.restoreExpirationTime)).append("\n");
        sb.append("    mediaUris: ").append(this.toIndentedString(this.mediaUris)).append("\n");
        sb.append("    estimatedTranscodeTimeMs: ").append(this.toIndentedString(this.estimatedTranscodeTimeMs)).append("\n");
        sb.append("    actualTranscodeTimeMs: ").append(this.toIndentedString(this.actualTranscodeTimeMs)).append("\n");
        sb.append("    archiveDate: ").append(this.toIndentedString(this.archiveDate)).append("\n");
        sb.append("    archiveMedium: ").append(this.toIndentedString((Object)this.archiveMedium)).append("\n");
        sb.append("    deleteDate: ").append(this.toIndentedString(this.deleteDate)).append("\n");
        sb.append("    exportDate: ").append(this.toIndentedString(this.exportDate)).append("\n");
        sb.append("    exportedDate: ").append(this.toIndentedString(this.exportedDate)).append("\n");
        sb.append("    outputDurationMs: ").append(this.toIndentedString(this.outputDurationMs)).append("\n");
        sb.append("    outputSizeInBytes: ").append(this.toIndentedString(this.outputSizeInBytes)).append("\n");
        sb.append("    maxAllowedRestorationsForOrg: ").append(this.toIndentedString(this.maxAllowedRestorationsForOrg)).append("\n");
        sb.append("    remainingRestorationsAllowedForOrg: ").append(this.toIndentedString(this.remainingRestorationsAllowedForOrg)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    recordingFileRole: ").append(this.toIndentedString((Object)this.recordingFileRole)).append("\n");
        sb.append("    recordingErrorStatus: ").append(this.toIndentedString((Object)this.recordingErrorStatus)).append("\n");
        sb.append("    originalRecordingStartTime: ").append(this.toIndentedString(this.originalRecordingStartTime)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileStateEnumDeserializer.class)
    public static enum FileStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ARCHIVED("ARCHIVED"),
        AVAILABLE("AVAILABLE"),
        DELETED("DELETED"),
        RESTORED("RESTORED"),
        RESTORING("RESTORING"),
        UPLOADING("UPLOADING"),
        ERROR("ERROR");

        private String value;

        private FileStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileStateEnum value : FileStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ArchiveMediumEnumDeserializer.class)
    public static enum ArchiveMediumEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLOUDARCHIVE("CLOUDARCHIVE");

        private String value;

        private ArchiveMediumEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ArchiveMediumEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ArchiveMediumEnum value : ArchiveMediumEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ArchiveMediumEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RecordingFileRoleEnumDeserializer.class)
    public static enum RecordingFileRoleEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CUSTOMER_EXPERIENCE("CUSTOMER_EXPERIENCE"),
        ADHOC("ADHOC");

        private String value;

        private RecordingFileRoleEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingFileRoleEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingFileRoleEnum value : RecordingFileRoleEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingFileRoleEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RecordingErrorStatusEnumDeserializer.class)
    public static enum RecordingErrorStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL_TRANSCRIPT_TOO_LARGE("EMAIL_TRANSCRIPT_TOO_LARGE");

        private String value;

        private RecordingErrorStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RecordingErrorStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RecordingErrorStatusEnum value : RecordingErrorStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RecordingErrorStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RecordingErrorStatusEnumDeserializer
    extends StdDeserializer<RecordingErrorStatusEnum> {
        public RecordingErrorStatusEnumDeserializer() {
            super(RecordingErrorStatusEnumDeserializer.class);
        }

        public RecordingErrorStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RecordingErrorStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RecordingFileRoleEnumDeserializer
    extends StdDeserializer<RecordingFileRoleEnum> {
        public RecordingFileRoleEnumDeserializer() {
            super(RecordingFileRoleEnumDeserializer.class);
        }

        public RecordingFileRoleEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RecordingFileRoleEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ArchiveMediumEnumDeserializer
    extends StdDeserializer<ArchiveMediumEnum> {
        public ArchiveMediumEnumDeserializer() {
            super(ArchiveMediumEnumDeserializer.class);
        }

        public ArchiveMediumEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ArchiveMediumEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FileStateEnumDeserializer
    extends StdDeserializer<FileStateEnum> {
        public FileStateEnumDeserializer() {
            super(FileStateEnumDeserializer.class);
        }

        public FileStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

