/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Annotation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RecordingMetadata
implements Serializable {
    private String id = null;
    private String name = null;
    private String conversationId = null;
    private String path = null;
    private String startTime = null;
    private String endTime = null;
    private String media = null;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private FileStateEnum fileState = null;
    private Date restoreExpirationTime = null;
    private Date archiveDate = null;
    private ArchiveMediumEnum archiveMedium = null;
    private Date deleteDate = null;
    private Date exportDate = null;
    private Date exportedDate = null;
    private Integer maxAllowedRestorationsForOrg = null;
    private Integer remainingRestorationsAllowedForOrg = null;
    private String sessionId = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public RecordingMetadata name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RecordingMetadata conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public RecordingMetadata path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public RecordingMetadata startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of the recording for screen recordings. Null for other types.")
    @JsonProperty(value="startTime")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public RecordingMetadata endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="endTime")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public RecordingMetadata media(String media) {
        this.media = media;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of media that the recording is. At the moment that could be audio, chat, email, or message.")
    @JsonProperty(value="media")
    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public RecordingMetadata annotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    @ApiModelProperty(example="null", value="Annotations that belong to the recording. Populated when recording filestate is AVAILABLE.")
    @JsonProperty(value="annotations")
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public RecordingMetadata fileState(FileStateEnum fileState) {
        this.fileState = fileState;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the current file state for a recording. Examples: Uploading, Archived, etc")
    @JsonProperty(value="fileState")
    public FileStateEnum getFileState() {
        return this.fileState;
    }

    public void setFileState(FileStateEnum fileState) {
        this.fileState = fileState;
    }

    public RecordingMetadata restoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time a restored recording will remain restored before being archived again. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="restoreExpirationTime")
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    public RecordingMetadata archiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="archiveDate")
    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public RecordingMetadata archiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of archive medium used. Example: CloudArchive")
    @JsonProperty(value="archiveMedium")
    public ArchiveMediumEnum getArchiveMedium() {
        return this.archiveMedium;
    }

    public void setArchiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
    }

    public RecordingMetadata deleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="deleteDate")
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public RecordingMetadata exportDate(Date exportDate) {
        this.exportDate = exportDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportDate")
    public Date getExportDate() {
        return this.exportDate;
    }

    public void setExportDate(Date exportDate) {
        this.exportDate = exportDate;
    }

    public RecordingMetadata exportedDate(Date exportedDate) {
        this.exportedDate = exportedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording was exported. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="exportedDate")
    public Date getExportedDate() {
        return this.exportedDate;
    }

    public void setExportedDate(Date exportedDate) {
        this.exportedDate = exportedDate;
    }

    public RecordingMetadata maxAllowedRestorationsForOrg(Integer maxAllowedRestorationsForOrg) {
        this.maxAllowedRestorationsForOrg = maxAllowedRestorationsForOrg;
        return this;
    }

    @ApiModelProperty(example="null", value="How many archive restorations the organization is allowed to have.")
    @JsonProperty(value="maxAllowedRestorationsForOrg")
    public Integer getMaxAllowedRestorationsForOrg() {
        return this.maxAllowedRestorationsForOrg;
    }

    public void setMaxAllowedRestorationsForOrg(Integer maxAllowedRestorationsForOrg) {
        this.maxAllowedRestorationsForOrg = maxAllowedRestorationsForOrg;
    }

    public RecordingMetadata remainingRestorationsAllowedForOrg(Integer remainingRestorationsAllowedForOrg) {
        this.remainingRestorationsAllowedForOrg = remainingRestorationsAllowedForOrg;
        return this;
    }

    @ApiModelProperty(example="null", value="The remaining archive restorations the organization has.")
    @JsonProperty(value="remainingRestorationsAllowedForOrg")
    public Integer getRemainingRestorationsAllowedForOrg() {
        return this.remainingRestorationsAllowedForOrg;
    }

    public void setRemainingRestorationsAllowedForOrg(Integer remainingRestorationsAllowedForOrg) {
        this.remainingRestorationsAllowedForOrg = remainingRestorationsAllowedForOrg;
    }

    public RecordingMetadata sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The session id represents an external resource id, such as email, call, chat, etc")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingMetadata recordingMetadata = (RecordingMetadata)o;
        return Objects.equals(this.id, recordingMetadata.id) && Objects.equals(this.name, recordingMetadata.name) && Objects.equals(this.conversationId, recordingMetadata.conversationId) && Objects.equals(this.path, recordingMetadata.path) && Objects.equals(this.startTime, recordingMetadata.startTime) && Objects.equals(this.endTime, recordingMetadata.endTime) && Objects.equals(this.media, recordingMetadata.media) && Objects.equals(this.annotations, recordingMetadata.annotations) && Objects.equals((Object)this.fileState, (Object)recordingMetadata.fileState) && Objects.equals(this.restoreExpirationTime, recordingMetadata.restoreExpirationTime) && Objects.equals(this.archiveDate, recordingMetadata.archiveDate) && Objects.equals((Object)this.archiveMedium, (Object)recordingMetadata.archiveMedium) && Objects.equals(this.deleteDate, recordingMetadata.deleteDate) && Objects.equals(this.exportDate, recordingMetadata.exportDate) && Objects.equals(this.exportedDate, recordingMetadata.exportedDate) && Objects.equals(this.maxAllowedRestorationsForOrg, recordingMetadata.maxAllowedRestorationsForOrg) && Objects.equals(this.remainingRestorationsAllowedForOrg, recordingMetadata.remainingRestorationsAllowedForOrg) && Objects.equals(this.sessionId, recordingMetadata.sessionId) && Objects.equals(this.selfUri, recordingMetadata.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.conversationId, this.path, this.startTime, this.endTime, this.media, this.annotations, this.fileState, this.restoreExpirationTime, this.archiveDate, this.archiveMedium, this.deleteDate, this.exportDate, this.exportedDate, this.maxAllowedRestorationsForOrg, this.remainingRestorationsAllowedForOrg, this.sessionId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    fileState: ").append(this.toIndentedString((Object)this.fileState)).append("\n");
        sb.append("    restoreExpirationTime: ").append(this.toIndentedString(this.restoreExpirationTime)).append("\n");
        sb.append("    archiveDate: ").append(this.toIndentedString(this.archiveDate)).append("\n");
        sb.append("    archiveMedium: ").append(this.toIndentedString((Object)this.archiveMedium)).append("\n");
        sb.append("    deleteDate: ").append(this.toIndentedString(this.deleteDate)).append("\n");
        sb.append("    exportDate: ").append(this.toIndentedString(this.exportDate)).append("\n");
        sb.append("    exportedDate: ").append(this.toIndentedString(this.exportedDate)).append("\n");
        sb.append("    maxAllowedRestorationsForOrg: ").append(this.toIndentedString(this.maxAllowedRestorationsForOrg)).append("\n");
        sb.append("    remainingRestorationsAllowedForOrg: ").append(this.toIndentedString(this.remainingRestorationsAllowedForOrg)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileStateEnumDeserializer.class)
    public static enum FileStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ARCHIVED("ARCHIVED"),
        AVAILABLE("AVAILABLE"),
        DELETED("DELETED"),
        RESTORED("RESTORED"),
        RESTORING("RESTORING"),
        UPLOADING("UPLOADING"),
        ERROR("ERROR");

        private String value;

        private FileStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileStateEnum value : FileStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ArchiveMediumEnumDeserializer.class)
    public static enum ArchiveMediumEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLOUDARCHIVE("CLOUDARCHIVE");

        private String value;

        private ArchiveMediumEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ArchiveMediumEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ArchiveMediumEnum value : ArchiveMediumEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ArchiveMediumEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ArchiveMediumEnumDeserializer
    extends StdDeserializer<ArchiveMediumEnum> {
        public ArchiveMediumEnumDeserializer() {
            super(ArchiveMediumEnumDeserializer.class);
        }

        public ArchiveMediumEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ArchiveMediumEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FileStateEnumDeserializer
    extends StdDeserializer<FileStateEnum> {
        public FileStateEnumDeserializer() {
            super(FileStateEnumDeserializer.class);
        }

        public FileStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

