/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Details for an mTLS certificate")
public class ActionCertificate
implements Serializable {
    private SigningAuthorityEnum signingAuthority = null;
    private String certificate = null;
    private StatusEnum status = null;
    private TypeEnum type = null;

    public ActionCertificate signingAuthority(SigningAuthorityEnum signingAuthority) {
        this.signingAuthority = signingAuthority;
        return this;
    }

    @ApiModelProperty(example="null", value="The Signing Authority for the certificate")
    @JsonProperty(value="signingAuthority")
    public SigningAuthorityEnum getSigningAuthority() {
        return this.signingAuthority;
    }

    public void setSigningAuthority(SigningAuthorityEnum signingAuthority) {
        this.signingAuthority = signingAuthority;
    }

    public ActionCertificate certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @ApiModelProperty(example="null", value="The certificate string")
    @JsonProperty(value="certificate")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public ActionCertificate status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The certificate status")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ActionCertificate type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The certificate type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionCertificate actionCertificate = (ActionCertificate)o;
        return Objects.equals((Object)this.signingAuthority, (Object)actionCertificate.signingAuthority) && Objects.equals(this.certificate, actionCertificate.certificate) && Objects.equals((Object)this.status, (Object)actionCertificate.status) && Objects.equals((Object)this.type, (Object)actionCertificate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signingAuthority, this.certificate, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionCertificate {\n");
        sb.append("    signingAuthority: ").append(this.toIndentedString((Object)this.signingAuthority)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SigningAuthorityEnumDeserializer.class)
    public static enum SigningAuthorityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DIGICERT("DigiCert"),
        GENESYS("Genesys");

        private String value;

        private SigningAuthorityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SigningAuthorityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SigningAuthorityEnum value : SigningAuthorityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SigningAuthorityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CURRENT("Current"),
        UPCOMING("Upcoming");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLIENT("Client");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SigningAuthorityEnumDeserializer
    extends StdDeserializer<SigningAuthorityEnum> {
        public SigningAuthorityEnumDeserializer() {
            super(SigningAuthorityEnumDeserializer.class);
        }

        public SigningAuthorityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SigningAuthorityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

